/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.gdstash.ui.util.EnabledComboBoxModel;
import org.gdstash.ui.util.EnabledComboBoxRenderer;

public class EnabledComboBox<E>
extends JComboBox<E> {
    private List<ActionListener> actionListeners;
    private EnabledComboBoxRenderer<E> renderer;

    public EnabledComboBox() {
        super(new EnabledComboBoxModel());
        this.renderer = new EnabledComboBoxRenderer((EnabledComboBoxModel)this.getModel());
        this.setRenderer(this.renderer);
        super.addActionListener(new ComboListener());
        this.actionListeners = new LinkedList<ActionListener>();
    }

    public EnabledComboBox(EnabledComboBoxModel<E> model) {
        super(model);
        this.renderer = new EnabledComboBoxRenderer(model);
        this.setRenderer(this.renderer);
        super.addActionListener(new ComboListener());
        this.actionListeners = new LinkedList<ActionListener>();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListeners.toArray();
    }

    @Override
    public void setModel(ComboBoxModel<E> model) {
        if (!(model instanceof EnabledComboBoxModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(model);
        this.renderer = new EnabledComboBoxRenderer((EnabledComboBoxModel)model);
        this.setRenderer(this.renderer);
    }

    public boolean isEnabled(int index) {
        EnabledComboBoxModel model = (EnabledComboBoxModel)this.getModel();
        return model.isEnabled(index);
    }

    public void setEnabled(boolean enabled, int index) {
        EnabledComboBoxModel model = (EnabledComboBoxModel)this.getModel();
        model.setEnabled(enabled, index);
    }

    public void setFirstEnabledIndex() {
        EnabledComboBoxModel model = (EnabledComboBoxModel)this.getModel();
        if (model == null) {
            return;
        }
        model.setFirstEnabledIndex();
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = EnabledComboBox.this.getSelectedIndex();
            if (index == -1) {
                return;
            }
            if (EnabledComboBox.this.isEnabled(index)) {
                EnabledComboBox.this.setSelectedIndex(index);
                for (ActionListener l : EnabledComboBox.this.actionListeners) {
                    l.actionPerformed(e);
                }
            }
        }
    }
}

