/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class EnabledComboBoxModel<E>
extends DefaultComboBoxModel<E> {
    private Vector<Boolean> enabled = new Vector();

    public EnabledComboBoxModel() {
    }

    public EnabledComboBoxModel(E[] items) {
        super(items);
    }

    public EnabledComboBoxModel(Vector<E> v) {
        super(v);
    }

    @Override
    public void addElement(E anObject) {
        this.addElement(anObject, true);
    }

    public void addElement(E anObject, boolean enabled) {
        Boolean b = null;
        b = enabled ? Boolean.TRUE : Boolean.FALSE;
        this.enabled.add(b);
        super.addElement(anObject);
    }

    @Override
    public void insertElementAt(E anObject, int index) {
        this.insertElementAt(anObject, index, true);
    }

    public void insertElementAt(E anObject, int index, boolean enabled) {
        super.insertElementAt(anObject, index);
        Boolean b = null;
        b = enabled ? Boolean.TRUE : Boolean.FALSE;
        this.enabled.add(index, b);
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.enabled.clear();
    }

    @Override
    public void removeElement(Object anObject) {
        int index = super.getIndexOf(anObject);
        if (index == -1) {
            return;
        }
        super.removeElement(anObject);
        this.enabled.remove(index);
    }

    @Override
    public void removeElementAt(int index) {
        super.removeElementAt(index);
        this.enabled.remove(index);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        int index = super.getIndexOf(anObject);
        if (index == -1) {
            return;
        }
        if (!this.isEnabled(index)) {
            return;
        }
        super.setSelectedItem(anObject);
    }

    public boolean isEnabled(int index) {
        Boolean b = null;
        try {
            b = this.enabled.get(index);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return b.equals(Boolean.TRUE);
    }

    public void setEnabled(boolean enabled, int index) {
        Boolean b = null;
        b = enabled ? Boolean.TRUE : Boolean.FALSE;
        this.enabled.set(index, b);
    }

    public void setFirstEnabledIndex() {
        int size = this.getSize();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            if (!this.isEnabled(i)) continue;
            index = i;
            break;
        }
        this.setSelectedItem(this.getElementAt(index));
    }
}

