/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.gdstash.ui.util.EnabledComboBoxModel;

public class EnabledComboBoxRenderer<E>
extends BasicComboBoxRenderer {
    private EnabledComboBoxModel model;
    private Color disabledColor;

    public EnabledComboBoxRenderer(EnabledComboBoxModel model) {
        this.model = model;
        this.disabledColor = Color.lightGray;
    }

    public void setDisabledColor(Color disabledColor) {
        this.disabledColor = disabledColor;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (this.model == null) {
            c.setBackground(super.getBackground());
            c.setForeground(super.getForeground());
            return c;
        }
        if (!this.model.isEnabled(index)) {
            if (isSelected) {
                c.setBackground(UIManager.getColor("ComboBox.background"));
            } else {
                c.setBackground(super.getBackground());
            }
            c.setForeground(this.disabledColor);
        } else {
            c.setBackground(super.getBackground());
            c.setForeground(super.getForeground());
        }
        return c;
    }
}

