/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.item.GDStash;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;

public class GDStashInfoList {
    public static List<GDStashFileInfo> gdStashFileInfos;
    public static List<String> modDirs;
    public static GDStashFileInfo defaultStash;

    public static void findStashes(GDStashFrame frame, GDStashFileInfo reloadInfo, GDLog log) {
        List<GDStashFileInfo> infos = gdStashFileInfos;
        gdStashFileInfos = new LinkedList<GDStashFileInfo>();
        modDirs = new LinkedList<String>();
        modDirs.add("");
        if (GDStashFrame.iniConfig == null) {
            return;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath == null) {
            return;
        }
        if (GDStashFrame.iniConfig.sectDir.savePath.isEmpty()) {
            return;
        }
        File file = new File(GDStashFrame.iniConfig.sectDir.savePath);
        if (file.isDirectory()) {
            GDStashInfoList.processStashDir(file, 0);
            GDStashInfoList.processStashDir(file, 1);
            GDStashInfoList.processModDir(file);
        }
        if (file.isFile()) {
            GDStashInfoList.processStashFile(file);
        }
        GDStashInfoList.adjustStashInfos(infos, reloadInfo, log);
        if (frame != null) {
            if (frame.pnlTransfer != null) {
                frame.pnlTransfer.refreshStashSelection();
            }
            if (frame.pnlCraft != null) {
                frame.pnlCraft.refreshStashSelection();
            }
        }
    }

    private static void processModDir(File dir) {
        try {
            File[] files = dir.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                String path;
                File file = files[i];
                if (file == null || !file.isDirectory() || (path = file.getCanonicalPath()).length() <= GDStashFrame.iniConfig.sectDir.savePath.length() || (path = path.substring(GDStashFrame.iniConfig.sectDir.savePath.length() + 1)).equals("main") || path.equals("user") || modDirs.contains(path)) continue;
                modDirs.add(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void processStashDir(File dir, int recDepth) {
        if (dir == null) {
            return;
        }
        if (recDepth < 0) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file == null) continue;
            if (file.isDirectory()) {
                GDStashInfoList.processStashDir(file, recDepth - 1);
            }
            if (!file.isFile() || recDepth != 0) continue;
            GDStashInfoList.processStashFile(file);
        }
    }

    private static void processStashFile(File file) {
        String s = file.getName().toUpperCase(GDConstants.LOCALE_US);
        if (s.equals("TRANSFER.GST") || s.equals("TRANSFER.GSH")) {
            GDStashFileInfo info = new GDStashFileInfo();
            info.stashFile = file;
            gdStashFileInfos.add(info);
        }
    }

    public static void adjustStashInfo(GDStashFileInfo info) {
        if (info.stashFile == null) {
            return;
        }
        try {
            info.fileName = info.stashFile.getCanonicalPath();
        }
        catch (IOException ex) {
            info.fileName = null;
        }
        String fn = info.stashFile.getName().toUpperCase(GDConstants.LOCALE_US);
        String sHC = null;
        sHC = fn.equals("TRANSFER.GSH") ? GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_STASH_HARDCORE") : GDMsgFormatter.getString(GDMsgFormatter.rbUI, "TXT_STASH_SOFTCORE");
        String dir = null;
        try {
            dir = info.stashFile.getParentFile().getCanonicalPath();
        }
        catch (IOException ex) {
            dir = null;
        }
        String s = null;
        if (dir == null) {
            dir = info.stashFile.getParentFile().getName();
            Object[] sArgs = new Object[]{sHC, dir};
            s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_STASH_SELECT_MOD", sArgs);
        } else if (dir.length() <= GDStashFrame.iniConfig.sectDir.savePath.length()) {
            Object[] sArgs = new Object[]{sHC};
            s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_STASH_SELECT_MAIN", sArgs);
        } else {
            dir = info.stashFile.getParentFile().getName();
            Object[] sArgs = new Object[]{sHC, dir};
            s = GDMsgFormatter.format(GDMsgFormatter.rbUI, "TXT_STASH_SELECT_MOD", sArgs);
        }
        info.stashInfo = s;
    }

    public static void adjustStashInfos(List<GDStashFileInfo> infos, GDStashFileInfo reloadInfo, GDLog log) {
        if (gdStashFileInfos == null) {
            return;
        }
        boolean found = false;
        GDStashFileInfo first = null;
        for (GDStashFileInfo info : gdStashFileInfos) {
            GDStashInfoList.adjustStashInfo(info);
            if (first == null) {
                first = info;
            }
            if (GDStashFrame.iniConfig.sectHistory.lastStash != null && GDStashFrame.iniConfig.sectHistory.lastStash.equals(info.fileName)) {
                if (info.gdStash == null) {
                    found = true;
                    info.gdStash = new GDStash(info.stashFile, log);
                    if (info.gdStash.hasStashErrors()) {
                        info.gdStash = null;
                    }
                }
                defaultStash = info;
                GDStashFrame.iniConfig.sectHistory.lastStash = info.fileName;
            }
            if (infos == null) continue;
            for (GDStashFileInfo info2 : infos) {
                if (info.fileName.equals(info2.fileName) && info2.gdStash != null && info2 != reloadInfo && info2.gdStash.hasChanged()) {
                    info.gdStash = info2.gdStash;
                }
                if (reloadInfo == null || !info.fileName.equals(reloadInfo.fileName)) continue;
                if (info.gdStash != null) {
                    info.gdStash.read(null);
                } else {
                    info.gdStash = new GDStash(info.stashFile);
                }
                GDStashFrame.iniConfig.sectHistory.lastStash = info.fileName;
            }
        }
        if (!found) {
            defaultStash = first;
            if (first != null) {
                GDStashFrame.iniConfig.sectHistory.lastStash = first.fileName;
                if (first.gdStash == null) {
                    first.gdStash = new GDStash(first.stashFile);
                    if (first.gdStash.hasStashErrors()) {
                        first.gdStash = null;
                    }
                }
            }
        }
    }

    public static String[] getStashInfos() {
        int size = 1;
        if (gdStashFileInfos != null) {
            size += gdStashFileInfos.size();
        }
        String[] cis = new String[size];
        cis[0] = "";
        if (gdStashFileInfos == null) {
            return cis;
        }
        if (gdStashFileInfos.size() == 0) {
            return cis;
        }
        cis = new String[--size];
        Iterator<GDStashFileInfo> iter = gdStashFileInfos.iterator();
        int i = 0;
        while (iter.hasNext()) {
            GDStashFileInfo info = iter.next();
            cis[i] = info.stashInfo;
            ++i;
        }
        return cis;
    }

    public static class GDStashFileInfo {
        public File stashFile;
        public String fileName;
        public String stashInfo;
        public GDStash gdStash;

        public void setFile(File file) {
            this.stashFile = file;
            GDStashInfoList.adjustStashInfo(this);
        }
    }
}

