/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.ui.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class WideComboBox<T>
extends JComboBox<T> {
    private boolean layingOut = false;

    public WideComboBox() {
    }

    public WideComboBox(T[] items) {
        super(items);
    }

    public WideComboBox(Vector<T> items) {
        super(items);
    }

    public WideComboBox(ComboBoxModel<T> aModel) {
        super(aModel);
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int maxWidth = 0;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (this.getItemAt(i) == null) continue;
                String s = this.getItemAt(i).toString();
                int currentWidth = metrics.stringWidth(s = this.stripTags(s));
                if (maxWidth >= currentWidth) continue;
                maxWidth = currentWidth;
            }
            dim.width = Math.max(dim.width, maxWidth) + 20;
        }
        return dim;
    }

    private String stripTags(String s) {
        String newS = "";
        String remainder = s;
        int pos = remainder.indexOf("<");
        while (pos != -1) {
            newS = newS + remainder.substring(0, pos);
            pos = remainder.indexOf(">", pos);
            remainder = remainder.substring(pos + 1);
            pos = remainder.indexOf("<");
        }
        newS = newS + remainder;
        return newS;
    }
}

