/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.util;

import java.awt.Component;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gdstash.ui.GDDialog;
import org.gdstash.ui.GDLogDialog;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;

public class GDLog {
    private List<LogEntry> list = new LinkedList<LogEntry>();
    private boolean error = false;

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ex.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private void addException(Throwable ex, int type) {
        this.list.add(new LogEntry(ex, type));
        if (type == 3) {
            this.error = true;
        }
    }

    public void addMessage(String s, int type) {
        this.list.add(new LogEntry(s, type));
        if (type == 3) {
            this.error = true;
        }
    }

    public void addMessage(String s) {
        this.addMessage(s, 0);
    }

    public void addSuccess(String s) {
        this.addMessage(s, 0);
    }

    public void addInfo(String s) {
        this.addMessage(s, 1);
    }

    public void addWarning(String s) {
        this.addMessage(s, 2);
    }

    public void addError(String s) {
        this.addMessage(s, 3);
    }

    public void addWarning(Throwable ex) {
        this.addException(ex, 2);
    }

    public void addError(Throwable ex) {
        this.addException(ex, 3);
    }

    public void addLog(GDLog log) {
        this.list.addAll(log.list);
        if (log.containsErrors()) {
            this.error = true;
        }
    }

    public boolean containsErrors() {
        return this.error;
    }

    public boolean containsMessages() {
        return !this.list.isEmpty();
    }

    public List<LogEntry> getLog() {
        return this.list;
    }

    public void clear() {
        this.list.clear();
        this.error = false;
    }

    public void showLog(Component owner, String message, int type) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(owner);
        GDLogDialog dlg = new GDLogDialog((Frame)frame, message, type, this);
        this.clear();
    }

    public void showLog(Component owner, String error) {
        this.showLog(owner, "", 3, error, false, true);
    }

    public void showLog(Component owner, String success, int type, String error) {
        this.showLog(owner, success, type, error, false, false);
    }

    public void showLog(Component owner, String success, int type, String error, boolean showEmpty) {
        this.showLog(owner, success, type, error, showEmpty, false);
    }

    public void showLog(Component owner, String success, int type, String error, boolean showEmpty, boolean errorOnly) {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(owner);
        if (this.containsErrors()) {
            GDLogDialog gDLogDialog = new GDLogDialog((Frame)frame, error, 3, this);
        } else if (this.containsMessages()) {
            if (!errorOnly) {
                GDLogDialog gDLogDialog = new GDLogDialog((Frame)frame, success, type, this);
            }
        } else if (showEmpty) {
            GDDialog dialog = new GDDialog(success, 1, frame, GDMsgFormatter.getString(GDMsgFormatter.rbUI, "SUCCESS"), true);
            dialog.setVisible(true);
        }
        this.clear();
    }

    public static class LogEntry {
        public static final int TYPE_SUCCESS = 0;
        public static final int TYPE_INFO = 1;
        public static final int TYPE_WARNING = 2;
        public static final int TYPE_ERROR = 3;
        public int type;
        public Throwable ex;
        public String str;

        public LogEntry(String s) {
            this(s, 0);
        }

        public LogEntry(String s, int type) {
            this.type = type;
            this.str = s;
            this.ex = null;
        }

        public LogEntry(Exception ex) {
            this(ex, 3);
        }

        public LogEntry(Throwable ex, int type) {
            this.type = type;
            this.ex = ex;
            this.str = ex.getMessage() == null || ex.getMessage().isEmpty() ? ex.toString() : ex.getMessage();
            this.str = this.str + GDConstants.LINE_SEPARATOR + GDLog.getStackTrace(ex);
        }
    }
}

