/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgLogger;

public class GDMsgFormatter {
    private static String resLanguage;
    private static String language;
    private static String country;
    public static Locale locale;
    private static MessageFormat msgFormatter;
    private static NumberFormat nrFormatter;
    public static ResourceBundle rbGD;
    public static ResourceBundle rbMsg;
    public static ResourceBundle rbUI;

    public static void setGDLocale(String language) {
        if (language == null) {
            return;
        }
        if (resLanguage != null && resLanguage.equals(language)) {
            return;
        }
        resLanguage = language;
        try {
            String fnGD = GDConstants.USER_DIR + GDConstants.FILE_SEPARATOR + "GrimDawn_" + language + ".properties";
            String fnUI = GDConstants.USER_DIR + GDConstants.FILE_SEPARATOR + "UI_" + language + ".properties";
            String fnMsg = GDConstants.USER_DIR + GDConstants.FILE_SEPARATOR + "Messages_" + language + ".properties";
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(fnGD)), GDConstants.CHARSET_PROPERTIES);){
                rbGD = new PropertyResourceBundle(reader);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(fnUI)), GDConstants.CHARSET_PROPERTIES);
            var5_9 = null;
            try {
                rbUI = new PropertyResourceBundle(reader);
            }
            catch (Throwable throwable) {
                var5_9 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var5_9 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var5_9.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(fnMsg)), GDConstants.CHARSET_PROPERTIES);
            var5_9 = null;
            try {
                rbMsg = new PropertyResourceBundle(reader);
            }
            catch (Throwable throwable) {
                var5_9 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var5_9 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var5_9.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            GDMsgFormatter.language = GDMsgFormatter.getString(rbUI, "LANGUAGE");
            country = GDMsgFormatter.getString(rbUI, "COUNTRY");
            locale = new Locale(GDMsgFormatter.language, country);
            msgFormatter = new MessageFormat("", locale);
            nrFormatter = NumberFormat.getNumberInstance(locale);
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
    }

    public static String format(ResourceBundle bundle, String tag, Object[] args) {
        String s = null;
        try {
            msgFormatter.applyPattern(bundle.getString(tag));
            s = msgFormatter.format(args);
        }
        catch (MissingResourceException ex) {
            Object[] errargs = new Object[]{tag};
            String msg = GDMsgFormatter.format(rbMsg, "ERR_TAG_UNKNOWN", errargs);
            GDMsgLogger.addError(msg);
            return "";
        }
        catch (IllegalArgumentException ex) {
            Object[] errargs = new Object[]{tag};
            String msg = GDMsgFormatter.format(rbMsg, "ERR_PATTERN_WRONG", errargs);
            GDMsgLogger.addError(msg);
            return "";
        }
        return s;
    }

    public static String getString(ResourceBundle bundle, String tag) {
        String s = null;
        try {
            s = bundle.getString(tag);
        }
        catch (MissingResourceException ex) {
            Object[] errargs = new Object[]{tag};
            String msg = GDMsgFormatter.format(rbMsg, "ERR_TAG_UNKNOWN", errargs);
            GDMsgLogger.addError(msg);
            return "";
        }
        return s;
    }
}

