<?php

/**
 * KDZS API: kdzs.logistics.mail.discern
 *
 * @author xuewu
 * @since 1.0, 2021-08-25
 */
class KdzsLogisticsMailDiscernRequest
{

    private $apiParas = array();
    /**
     *快递运单号
     * 必填
     */
    private $mailNo;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getMailNo()
    {
        return $this->mailNo;
    }

    public function setMailNo($mailNo)
    {
        $this->mailNo = $mailNo;
        $this->apiParas["mailNo"] = $mailNo;
    }

    public function getApiMethodName()
    {
        return "kdzs.logistics.mail.discern";
    }

    public function check()
    {
        RequestCheckUtil::checkNotNull($this->mailNo, "mailNo");
    }

    public function putOtherTextParam($key, $value)
    {
        $this->apiParas[$key] = $value;
        $this->$key = $value;
    }
}
