<?php

/**
 * KDZS API: kdzs.logistics.trace.map.get
 *
 * @author xuewu
 * @since 1.0, 2021-08-25
 */
class KdzsLogisticsTraceMapGetRequest
{

    private $apiParas = array();

    /**
     *快递公司编码 例如圆通:YTO
     * 必填
     */
    private $cpCode;

    /**
     *快递运单号
     * 必填
     */
    private $mailNo;

    /**
     *出发地-省市区
     * 必填
     */
    private $origin;

    /**
     *目的地-省市区
     * 必填
     */
    private $destination;

    /**
     *收件详细地址
     * 必填
     */
    private $receiveAddress;

    /**
     *返回类型，物流轨迹地图数据:JSON（暂未开放）物流轨迹地图PC链接:PC（暂未开放）物流轨迹地图
     * 非必填
     */
    private $responseModel;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getCpCode()
    {
        return $this->cpCode;
    }

    public function setCpCode($cpCode)
    {
        $this->cpCode = $cpCode;
        $this->apiParas["cpCode"] = $cpCode;
    }

    public function getMailNo()
    {
        return $this->mailNo;
    }

    public function setMailNo($mailNo)
    {
        $this->mailNo = $mailNo;
        $this->apiParas["mailNo"] = $mailNo;
    }

    public function getOrigin()
    {
        return $this->origin;
    }

    public function setOrigin($origin)
    {
        $this->origin = $origin;
        $this->apiParas["origin"] = $origin;
    }

    public function getDestination()
    {
        return $this->destination;
    }

    public function setDestination($destination)
    {
        $this->destination = $destination;
        $this->apiParas["destination"] = $destination;
    }

    public function getReceiveAddress()
    {
        return $this->receiveAddress;
    }

    public function setReceiveAddress($receiveAddress)
    {
        $this->receiveAddress = $receiveAddress;
        $this->apiParas["receiveAddress"] = $receiveAddress;
    }

    public function getResponseModel()
    {
        return $this->responseModel;
    }

    public function setResponseModel($responseModel)
    {
        $this->responseModel = $responseModel;
        $this->apiParas["responseModel"] = $responseModel;
    }


    public function getApiMethodName()
    {
        return "kdzs.logistics.trace.map.get";
    }

    public function check()
    {
        RequestCheckUtil::checkNotNull($this->cpCode, "cpCode");
        RequestCheckUtil::checkNotNull($this->mailNo, "mailNo");
        RequestCheckUtil::checkNotNull($this->origin, "origin");
        RequestCheckUtil::checkNotNull($this->destination, "destination");
        RequestCheckUtil::checkNotNull($this->receiveAddress, "receiveAddress");
    }

    public function putOtherTextParam($key, $value)
    {
        $this->apiParas[$key] = $value;
        $this->$key = $value;
    }
}
