<?php

/**
 * KDZS API: kdzs.logistics.trace.search
 *
 * @author xuewu
 * @since 1.0, 2021-08-25
 */
class KdzsLogisticsTraceSearchRequest
{

    private $apiParas = array();

    /**
     *快递公司编码 例如圆通:YTO
     * 必填
     */
    private $cpCode;

    /**
     *快递运单号
     * 必填
     */
    private $mailNo;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getCpCode()
    {
        return $this->cpCode;
    }

    public function setCpCode($cpCode)
    {
        $this->cpCode = $cpCode;
        $this->apiParas["cpCode"] = $cpCode;
    }

    public function getMailNo()
    {
        return $this->mailNo;
    }

    public function setMailNo($mailNo)
    {
        $this->mailNo = $mailNo;
        $this->apiParas["mailNo"] = $mailNo;
    }

    public function getApiMethodName()
    {
        return "kdzs.logistics.trace.search";
    }

    public function check()
    {
        RequestCheckUtil::checkNotNull($this->cpCode, "cpCode");
        RequestCheckUtil::checkNotNull($this->mailNo, "mailNo");
    }

    public function putOtherTextParam($key, $value)
    {
        $this->apiParas[$key] = $value;
        $this->$key = $value;
    }
}
