<?php

/**
 * KDZS API: kdzs.logistics.trace.subscribe
 *
 * @author xuewu
 * @since 1.0, 2021-08-25
 */
class KdzsLogisticsTraceSubscribeRequest
{

    private $apiParas = array();

    /**
     *快递公司编码 例如圆通:YTO
     * 必填
     */
    private $cpCode;

    /**
     *快递运单号
     * 必填
     */
    private $mailNo;

    /**
     *寄件人信息，传入提高订阅成功率
     * 非必填
     */
    private $sender;

    /**
     *收件人信息，传入提高订阅成功率
     * 非必填
     */
    private $receiver;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getCpCode()
    {
        return $this->cpCode;
    }

    public function setCpCode($cpCode)
    {
        $this->cpCode = $cpCode;
        $this->apiParas["cpCode"] = $cpCode;
    }

    public function getMailNo()
    {
        return $this->mailNo;
    }

    public function setMailNo($mailNo)
    {
        $this->mailNo = $mailNo;
        $this->apiParas["mailNo"] = $mailNo;
    }

    public function getSender()
    {
        return $this->sender;
    }

    public function setSender($sender)
    {
        $this->sender = $sender;
        $this->apiParas["sender"] = $sender;
    }

    public function getReceiver()
    {
        return $this->receiver;
    }

    public function setReceiver($receiver)
    {
        $this->receiver = $receiver;
        $this->apiParas["receiver"] = $receiver;
    }


    public function getApiMethodName()
    {
        return "kdzs.logistics.trace.subscribe";
    }

    public function check()
    {
        RequestCheckUtil::checkNotNull($this->cpCode, "cpCode");
        RequestCheckUtil::checkNotNull($this->mailNo, "mailNo");
    }

    public function putOtherTextParam($key, $value)
    {
        $this->apiParas[$key] = $value;
        $this->$key = $value;
    }
}

class SenderReceiver{

    private $apiParas = array();

    private $address;

    private $tel;

    private $name;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getAddress()
    {
        return $this->address;
    }

    public function setAddress($address)
    {
        $this->address = $address;
        $this->apiParas["address"] = $address->getApiParas();
    }

    public function getTel()
    {
        return $this->tel;
    }

    public function setTel($tel)
    {
        $this->tel = $tel;
        $this->apiParas["tel"] = $tel;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
        $this->apiParas["name"] = $name;
    }



}
class Address{

    private $apiParas = array();

    private $address;

    private $district;

    private $city;

    private $province;

    public function getApiParas()
    {
        return $this->apiParas;
    }

    public function getAddress()
    {
        return $this->address;
    }

    public function setAddress($address)
    {
        $this->address = $address;
        $this->apiParas["address"] = $address;
    }

    public function getDistrict()
    {
        return $this->district;
    }

    public function setDistrict($district)
    {
        $this->district = $district;
        $this->apiParas["district"] = $district;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city)
    {
        $this->city = $city;
        $this->apiParas["city"] = $city;
    }

    public function getProvince()
    {
        return $this->province;
    }

    public function setProvince($province)
    {
        $this->province = $province;
        $this->apiParas["province"] = $province;
    }

}