local assets =
{ 
    Asset("ANIM", "anim/gamiglasses.zip"),
    Asset("ANIM", "anim/gamiglasses_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/gamiglasses.xml"),
    Asset("IMAGE", "images/inventoryimages/gamiglasses.tex"),
}

local prefabs = 
{
}


local function infrared(inst)
	
	if inst.isWeared and not inst.isDropped then
		if false --[[GetSeasonManager().current_season == SEASONS.CAVES --]] then
			inst.Light:Enable(true)
		else
			if TheWorld.state.phase == "day" then
				inst.Light:Enable(false)
			elseif TheWorld.state.phase == "dusk" then
				inst.Light:SetIntensity(.5)
				inst.Light:Enable(true)
			elseif TheWorld.state.phase == "night" then
				inst.Light:SetIntensity(.8)
				inst.Light:Enable(true)
			end
		end
	else
		inst.Light:Enable(false)
	end

end


local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "gamiglasses_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
		
		inst.isWeared = true
		inst.isDropped = false
		infrared(inst)	
	
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		
		inst.isWeared = false
		inst.isDropped = false
		infrared(inst)	
	
end

local function onDrop(inst)
	inst.isDropped = true
	inst.isWeared = false
	infrared(inst)
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("gamiglasses")
    inst.AnimState:SetBuild("gamiglasses")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("hat")
	
	inst.isWeared = false
	inst.isDropped = false
	
	local light = inst.entity:AddLight()
    light:SetFalloff(0.4)
    light:SetIntensity(.8)
    light:SetRadius(5)
    light:SetColour(30/255, 215/255, 30/255)
    light:Enable(false)	
	
    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true	
    inst.components.inventoryitem.imagename = "gamiglasses"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gamiglasses.xml"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	inst.components.inventoryitem:SetOnDroppedFn( onDrop )	
 	inst.components.inventoryitem.keepondeath = true
	
	--[[
	inst:ListenForEvent( "dusktime", function() infrared(inst) end , GetWorld())
    inst:ListenForEvent( "daytime", function() infrared(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() infrared(inst) end , GetWorld())
    --]]
	
	inst:ListenForEvent("phasechanged", function() infrared(inst) end, TheWorld)

	if not inst.components.characterspecific then
		inst:AddComponent("characterspecific")
	end
 
	inst.components.characterspecific:SetOwner("grell")
	inst.components.characterspecific:SetStorable(true)
	inst.components.characterspecific:SetComment("Red glasses.")

 	
    return inst

end

return  Prefab("common/inventory/gamiglasses", fn, assets, prefabs)