
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/grell.zip" ),
        Asset( "ANIM", "anim/ghost_grell_build.zip" ),
}
local prefabs = {}
local start_inv = {
    "gamiglasses",
    "grell_chainsaw",	
}

local function onkill(inst, data)
	if data.afflicter == inst 
		and not data.inst:HasTag("veggie") 
		and not data.inst:HasTag("structure") then
		local delta = (data.inst.components.combat.defaultdamage) * 0.5
 		if data.inst:HasTag("player") then delta = TUNING.WILSON_HEALTH * 0.5 end
        inst.components.sanity:DoDelta(delta)


	end
end

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "grell.tex" )
end


-- This initializes for the host only
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(150)
	
	inst.components.temperature.inherentinsulation = 20
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)	
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.1)	
	
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = (-TUNING.SANITYAURA_MED)	
	inst.components.combat.damagemultiplier = 0.8
	inst.components.sanity.night_drain_mult = ( TUNING.WENDY_SANITY_MULT * -2 )	
	inst.components.sanity.neg_aura_mult = 0.4
	inst.components.sanity.dapperness = (-TUNING.DAPPERNESS_MED)	
	
    inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, TheWorld)	
end

return MakePlayerCharacter("grell", prefabs, assets, common_postinit, master_postinit, start_inv)
