local assets=
{ 
    Asset("ANIM", "anim/grell_chainsaw.zip"),
    Asset("ANIM", "anim/swap_grell_chainsaw.zip"), 

    Asset("ATLAS", "images/inventoryimages/grell_chainsaw.xml"),
    Asset("IMAGE", "images/inventoryimages/grell_chainsaw.tex"),
}

local prefabs = 
{
}

local function fn()

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_grell_chainsaws", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_grell_chainsaw", "grell_chainsaw")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()	
    MakeInventoryPhysics(inst)
 	inst.entity:AddNetwork()
	
    anim:SetBank("grell_chainsaw")
    anim:SetBuild("grell_chainsaw")
    anim:PlayAnimation("idle")
	inst:AddTag("shadow")
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(70)

	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 8)

	
	if not TheWorld.ismastersim then
   return inst
end	

    inst:AddComponent("inspectable")
     
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "grell_chainsaw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/grell_chainsaw.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
 	inst.components.inventoryitem.keepondeath = true
    inst.components.equippable.dapperness = (TUNING.CRAZINESS_MED * 0.5)
	
	if not inst.components.characterspecific then
		inst:AddComponent("characterspecific")
	end
 
	inst.components.characterspecific:SetOwner("grell")
	inst.components.characterspecific:SetStorable(true)
	inst.components.characterspecific:SetComment("Strong to protect.") 

    return inst
end

return  Prefab("common/inventory/grell_chainsaw", fn, assets, prefabs)