local STRINGS = GLOBAL.STRINGS

GLOBAL.STRINGS.NAMES.HAT_KING = "Crown"
GLOBAL.STRINGS.CHARACTERS.GENERIC.HAT_KING = "The crown of the pig king!"

Assets = {
	Asset("ANIM", "anim/pig_king.zip"),
	Asset("SOUND", "sound/pig.fsb"),
}

PrefabFiles = {
	"hat_king",
}

local prefabs = {
	"gold",
    "pigskin",
    "meat",
}

function OnAttackedPig(inst, data)
    --print(inst, "OnAttackedPig")
	MAX_TARGET_SHARES = 5
	SHARE_TARGET_DIST = 30

    attacker = data.attacker

    inst.components.combat:SetTarget(attacker)

    if inst:HasTag("werepig") then
        inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("werepig") end, MAX_TARGET_SHARES)
    elseif inst:HasTag("guard") then
            inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and (dude:HasTag("guard") or not attacker:HasTag("pig")) end, MAX_TARGET_SHARES)
    else
        if not (attacker:HasTag("pig") and attacker:HasTag("guard") ) then
            inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and not dude:HasTag("werepig") end, MAX_TARGET_SHARES)
        end
		
    end

end

function KillablePigKing(inst, item)

	local item = "trinket_"..tostring(math.random(1, 7))
	local item2 = "trinket_"..tostring(math.random(1, 7))
	local item3 = "trinket_"..tostring(math.random(1, 7))
	
	--inst:AddComponent("trader")
	inst:ListenForEvent("attacked", OnAttackedPig)
	inst:AddTag("guard")	
	inst:AddTag("pig")
	
	--local adyingking = TheSim:FindFirstEntityWithTag("king")
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(160)
	
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({
		"goldnugget", "goldnugget", "goldnugget", "goldnugget", 
		"pigskin", "meat", "meat", "meat", "hat_king"
	})
			
	inst:AddComponent("combat")
	inst.components.combat.hiteffectsymbol = "body"
	    
	--Sorry, no equipping the pig king.	
	--if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        --local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        --if current then
            --inst.components.inventory:DropItem(current)
        --end      
        --inst.components.inventory:Equip(item)
        --inst.AnimState:Show("hat")	
    --end
	
	inst:ListenForEvent("healthdelta", function(inst, data)
		if data.newpercent < data.oldpercent then
			inst.AnimState:PlayAnimation("unimpressed")
			inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
		end
	end)
	
	inst:ListenForEvent("healthdelta", function(inst, data)
		if data.newpercent == 0 then
			inst.AnimState:PlayAnimation("sleep_pre")
			inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingReject")
		end
	end)	

	inst:ListenForEvent("death", function(inst)
		inst.components.lootdropper:DropLoot()  
		inst.SoundEmitter:PlaySound("dontstarve/pig/PigKingThrowGold")
		print "Off with their heads!"	
		if item then
			inst.components.lootdropper:SpawnLootPrefab(item)
			inst.components.lootdropper:SpawnLootPrefab(item2)
			inst.components.lootdropper:SpawnLootPrefab(item3)
		end		
	end)
		
end

AddPrefabPostInit("pigking", KillablePigKing)
AddPrefabPostInit("hat_king")