
local Assets =
{
	Asset("ANIM", "anim/hat_king.zip"),
    Asset("IMAGE", "images/inventoryimages/hat_king.tex"),
     Asset("ATLAS", "images/inventoryimages/hat_king.xml"),  
}

local prefabs = {"pigking"}

local banddt = 1
local function band_update( inst )
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if owner and owner.components.leader then
		local x,y,z = owner.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x,y,z, TUNING.ONEMANBAND_RANGE, {"pig"})
		for k,v in pairs(ents) do
			if v.components.follower and not v.components.follower.leader and not v:HasTag("werepig") and not owner.components.leader:IsFollower(v) and owner.components.leader.numfollowers < 10 then
				owner.components.leader:AddFollower(v)
				--owner.components.sanity:DoDelta(-TUNING.SANITY_MED)
			end
		end

		for k,v in pairs(owner.components.leader.followers) do
	        if k:HasTag("pig") and k.components.follower then
	            k.components.follower:AddLoyaltyTime(3)
	        end
   		end
	end
end

local function slurphunger(inst, owner)
    if (owner.components.hunger and owner.components.hunger.current > 0 )then
        owner.components.hunger:DoDelta(-3) 
		
    end
end

local function band_disable(inst)

	if inst.updatetask then
		inst.updatetask:Cancel()
		inst.updatetask = nil
	end
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
    owner.components.leader:RemoveFollowersByTag("pig")
	owner.components.leader:RemoveFollowersByTag("guard")
end

local function band_enable( inst )
	inst.updatetask = inst:DoPeriodicTask(banddt, band_update, 1)
end

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "hat_king", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
        owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")  
		owner:AddTag("king")
        
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAIR")
		end
        
		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end
		
		band_enable(inst)
		inst.task = inst:DoPeriodicTask(2, function() slurphunger(inst, owner) end)
		
		local cursed = false
		local timing = GetClock():GetMoonPhase()
		local cycle = GetClock():GetPhase()
		if timing == "new" and cycle == "night" then
			cursed = true
		end
		
		if owner.prefab == "pigman" and cursed == true then
			owner:Remove()
			GetClock():MakeNextDay()
			TheFrontEnd:Fade(false,0.1)
			local pigking = SpawnPrefab("pigking")
			pigking.Transform:SetPosition(inst.Transform:GetWorldPosition())
			print "On with his head!"
			TheFrontEnd:Fade(true,1)
		end
		
    end

    local function onunequip(inst, owner)
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")


		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end

		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end
		
		band_disable(inst)
		if inst.task then inst.task:Cancel() inst.task = nil end
    end
	
local function fn(Sim)
        local inst = CreateEntity()
		
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("footballhat")
        inst.AnimState:SetBuild("hat_king")
        inst.AnimState:PlayAnimation("anim")

        inst:AddTag("hat")

        inst:AddComponent("inspectable")

        inst:AddComponent("inventoryitem")
        inst:AddComponent("tradable")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_king.xml"

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
        inst.components.equippable:SetOnEquip( onequip )
        inst.components.equippable:SetOnUnequip( onunequip )
		
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = -3
		
		inst:AddComponent("insulator")
        inst.components.insulator.insulation = TUNING.INSULATION_LARGE
		
		inst:AddComponent("edible")
		inst.components.edible.foodtype = "VEGGIE"
		
        return inst
end

return Prefab( "hat_king", fn, Assets)

