/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.SecurityUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefiningClassLoader
extends ClassLoader
implements GeneratedClassLoader {
    private final ClassLoader parentLoader;
    private ClassLoader contextLoader;
    private static Method method_getContextClassLoader;

    public DefiningClassLoader() {
        this.parentLoader = this.getClass().getClassLoader();
        this.init();
    }

    public DefiningClassLoader(ClassLoader parentLoader) {
        this.parentLoader = parentLoader;
        this.init();
    }

    private void init() {
        this.contextLoader = null;
        if (method_getContextClassLoader != null) {
            try {
                this.contextLoader = (ClassLoader)method_getContextClassLoader.invoke((Object)Thread.currentThread(), ScriptRuntime.emptyArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (this.contextLoader == this.parentLoader) {
                this.contextLoader = null;
            }
        }
    }

    @Override
    public Class<?> defineClass(String name, byte[] data) {
        return super.defineClass(name, data, 0, data.length, SecurityUtilities.getProtectionDomain(this.getClass()));
    }

    @Override
    public void linkClass(Class<?> cl) {
        this.resolveClass(cl);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl == null) {
            if (this.contextLoader == null) {
                cl = this.loadFromParent(name);
            } else {
                try {
                    cl = this.loadFromParent(name);
                }
                catch (ClassNotFoundException ex) {
                    cl = this.contextLoader.loadClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private Class loadFromParent(String name) throws ClassNotFoundException {
        if (this.parentLoader != null) {
            return this.parentLoader.loadClass(name);
        }
        return this.findSystemClass(name);
    }

    static {
        try {
            Class<?> threadClass = Class.forName("java.lang.Thread");
            method_getContextClassLoader = threadClass.getDeclaredMethod("getContextClassLoader", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

