/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x509;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.DistributionPointName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ReasonFlags;
import com.aspose.cad.internal.bouncycastle.util.Strings;

public class IssuingDistributionPoint
extends ASN1Object {
    private DistributionPointName a;
    private boolean b;
    private boolean c;
    private ReasonFlags d;
    private boolean e;
    private boolean f;
    private ASN1Sequence g;

    public static IssuingDistributionPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return IssuingDistributionPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static IssuingDistributionPoint getInstance(Object object) {
        if (object instanceof IssuingDistributionPoint) {
            return (IssuingDistributionPoint)object;
        }
        if (object != null) {
            return new IssuingDistributionPoint(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public IssuingDistributionPoint(DistributionPointName distributionPointName, boolean bl2, boolean bl3, ReasonFlags reasonFlags, boolean bl4, boolean bl5) {
        this.a = distributionPointName;
        this.e = bl4;
        this.f = bl5;
        this.c = bl3;
        this.b = bl2;
        this.d = reasonFlags;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (distributionPointName != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, distributionPointName));
        }
        if (bl2) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, ASN1Boolean.getInstance(true)));
        }
        if (bl3) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, ASN1Boolean.getInstance(true)));
        }
        if (reasonFlags != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, reasonFlags));
        }
        if (bl4) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 4, ASN1Boolean.getInstance(true)));
        }
        if (bl5) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 5, ASN1Boolean.getInstance(true)));
        }
        this.g = new DERSequence(aSN1EncodableVector);
    }

    public IssuingDistributionPoint(DistributionPointName distributionPointName, boolean bl2, boolean bl3) {
        this(distributionPointName, false, false, null, bl2, bl3);
    }

    private IssuingDistributionPoint(ASN1Sequence aSN1Sequence) {
        this.g = aSN1Sequence;
        block8: for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = DistributionPointName.getInstance(aSN1TaggedObject, true);
                    continue block8;
                }
                case 1: {
                    this.b = ASN1Boolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 2: {
                    this.c = ASN1Boolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 3: {
                    this.d = new ReasonFlags(ReasonFlags.getInstance(aSN1TaggedObject, false));
                    continue block8;
                }
                case 4: {
                    this.e = ASN1Boolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                case 5: {
                    this.f = ASN1Boolean.getInstance(aSN1TaggedObject, false).isTrue();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in IssuingDistributionPoint");
                }
            }
        }
    }

    public boolean onlyContainsUserCerts() {
        return this.b;
    }

    public boolean onlyContainsCACerts() {
        return this.c;
    }

    public boolean isIndirectCRL() {
        return this.e;
    }

    public boolean onlyContainsAttributeCerts() {
        return this.f;
    }

    public DistributionPointName getDistributionPoint() {
        return this.a;
    }

    public ReasonFlags getOnlySomeReasons() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.g;
    }

    public String toString() {
        String string = Strings.lineSeparator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IssuingDistributionPoint: [");
        stringBuffer.append(string);
        if (this.a != null) {
            this.a(stringBuffer, string, "distributionPoint", this.a.toString());
        }
        if (this.b) {
            this.a(stringBuffer, string, "onlyContainsUserCerts", this.a(this.b));
        }
        if (this.c) {
            this.a(stringBuffer, string, "onlyContainsCACerts", this.a(this.c));
        }
        if (this.d != null) {
            this.a(stringBuffer, string, "onlySomeReasons", this.d.toString());
        }
        if (this.f) {
            this.a(stringBuffer, string, "onlyContainsAttributeCerts", this.a(this.f));
        }
        if (this.e) {
            this.a(stringBuffer, string, "indirectCRL", this.a(this.e));
        }
        stringBuffer.append("]");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private void a(StringBuffer stringBuffer, String string, String string2, String string3) {
        String string4 = "    ";
        stringBuffer.append(string4);
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append(string4);
        stringBuffer.append(string4);
        stringBuffer.append(string3);
        stringBuffer.append(string);
    }

    private String a(boolean bl2) {
        return bl2 ? "true" : "false";
    }
}

