/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.ResponseData;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.SingleResponse;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.OCSPException;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.RespID;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.SingleResp;
import com.aspose.cad.internal.bouncycastle.cert.ocsp.a;
import com.aspose.cad.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.cad.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.cad.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class BasicOCSPResp
implements Encodable {
    private BasicOCSPResponse a;
    private ResponseData b;
    private Extensions c;

    public BasicOCSPResp(BasicOCSPResponse basicOCSPResponse) {
        this.a = basicOCSPResponse;
        this.b = basicOCSPResponse.getTbsResponseData();
        this.c = Extensions.getInstance(basicOCSPResponse.getTbsResponseData().getResponseExtensions());
    }

    public byte[] getTBSResponseData() {
        try {
            return this.a.getTbsResponseData().getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public AlgorithmIdentifier getSignatureAlgorithmID() {
        return this.a.getSignatureAlgorithm();
    }

    public int getVersion() {
        return this.b.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.b.getResponderID());
    }

    public Date getProducedAt() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.a(this.b.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.b.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i2 = 0; i2 != singleRespArray.length; ++i2) {
            singleRespArray[i2] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return singleRespArray;
    }

    public boolean hasExtensions() {
        return this.c != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.c != null) {
            return this.c.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.c(this.c);
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.a(this.c);
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.b(this.c);
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        return this.a.getSignatureAlgorithm().getAlgorithm();
    }

    public byte[] getSignature() {
        return this.a.getSignature().getOctets();
    }

    public X509CertificateHolder[] getCerts() {
        if (this.a.getCerts() != null) {
            ASN1Sequence aSN1Sequence = this.a.getCerts();
            if (aSN1Sequence != null) {
                X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[aSN1Sequence.size()];
                for (int i2 = 0; i2 != x509CertificateHolderArray.length; ++i2) {
                    x509CertificateHolderArray[i2] = new X509CertificateHolder(Certificate.getInstance(aSN1Sequence.getObjectAt(i2)));
                }
                return x509CertificateHolderArray;
            }
            return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.a;
        }
        return com.aspose.cad.internal.bouncycastle.cert.ocsp.a.a;
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws OCSPException {
        try {
            ContentVerifier contentVerifier = contentVerifierProvider.get(this.a.getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(this.a.getTbsResponseData().getEncoded("DER"));
            outputStream.close();
            return contentVerifier.verify(this.getSignature());
        }
        catch (Exception exception) {
            throw new OCSPException("exception processing sig: " + exception, exception);
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp basicOCSPResp = (BasicOCSPResp)object;
        return this.a.equals(basicOCSPResp.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }
}

