/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.CharacterSetFactory;
import net.sf.saxon.charcode.PluggableCharacterSet;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public abstract class Emitter
implements Result,
Receiver {
    protected PipelineConfiguration pipelineConfig;
    protected NamePool namePool;
    protected String systemId;
    protected StreamResult streamResult;
    protected Writer writer;
    protected OutputStream outputStream;
    protected Properties outputProperties;
    protected CharacterSet characterSet = null;
    protected boolean allCharactersEncodable = false;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipelineConfig = pipe;
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfig;
    }

    public Configuration getConfiguration() {
        return this.pipelineConfig.getConfiguration();
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setOutputProperties(Properties details) throws XPathException {
        if (this.characterSet == null) {
            this.characterSet = CharacterSetFactory.getCharacterSet(details, this.getPipelineConfiguration());
            this.allCharactersEncodable = this.characterSet instanceof UnicodeCharacterSet;
        }
        this.outputProperties = details;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setStreamResult(StreamResult result) throws XPathException {
        this.streamResult = result;
    }

    protected void makeWriter() throws XPathException {
        OutputStream os;
        if (this.writer != null) {
            return;
        }
        if (this.streamResult == null) {
            throw new IllegalStateException("Emitter must have either a Writer or a StreamResult to write to");
        }
        this.writer = this.streamResult.getWriter();
        if (this.writer == null && (os = this.streamResult.getOutputStream()) != null) {
            this.setOutputStream(os);
        }
        if (this.writer == null) {
            String uriString = this.streamResult.getSystemId();
            if (uriString == null) {
                throw new XPathException("No system ID supplied for result file");
            }
            try {
                URI uri = new URI(uriString);
                if (!uri.isAbsolute()) {
                    try {
                        uri = new File(uriString).getAbsoluteFile().toURI();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                File file = new File(uri);
                this.setOutputStream(new FileOutputStream(file));
                this.streamResult.setOutputStream(this.outputStream);
            }
            catch (FileNotFoundException fnf) {
                throw new XPathException(fnf);
            }
            catch (URISyntaxException use) {
                throw new XPathException(use);
            }
            catch (IllegalArgumentException iae) {
                throw new XPathException(iae);
            }
        }
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer writer) throws XPathException {
        this.writer = writer;
        if (writer instanceof OutputStreamWriter && this.outputProperties != null) {
            String enc = ((OutputStreamWriter)writer).getEncoding();
            this.outputProperties.setProperty("encoding", enc);
            this.characterSet = CharacterSetFactory.getCharacterSet(this.outputProperties, this.getPipelineConfiguration());
            this.allCharactersEncodable = this.characterSet instanceof UnicodeCharacterSet;
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputStream(OutputStream stream) throws XPathException {
        this.outputStream = stream;
        if (this.usesWriter()) {
            String encoding = this.outputProperties.getProperty("encoding");
            if (encoding == null) {
                encoding = "UTF8";
                this.allCharactersEncodable = true;
            } else if (encoding.equalsIgnoreCase("UTF-8")) {
                encoding = "UTF8";
                this.allCharactersEncodable = true;
            }
            if (this.characterSet instanceof PluggableCharacterSet) {
                encoding = ((PluggableCharacterSet)this.characterSet).getEncodingName();
            }
            while (true) {
                try {
                    String javaEncoding = encoding;
                    if (encoding.equalsIgnoreCase("iso-646") || encoding.equalsIgnoreCase("iso646")) {
                        javaEncoding = "US-ASCII";
                    }
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, javaEncoding));
                }
                catch (Exception err) {
                    if (encoding.equalsIgnoreCase("UTF8")) {
                        throw new XPathException("Failed to create a UTF8 output writer");
                    }
                    XPathException de = new XPathException("Encoding " + encoding + " is not supported: using UTF8");
                    de.setErrorCode("SESU0007");
                    try {
                        this.getPipelineConfiguration().getErrorListener().error(de);
                    }
                    catch (TransformerException e) {
                        throw XPathException.makeXPathException(e);
                    }
                    encoding = "UTF8";
                    this.characterSet = UnicodeCharacterSet.getInstance();
                    this.allCharactersEncodable = true;
                    this.outputProperties.setProperty("encoding", "UTF-8");
                    continue;
                }
                break;
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
    }
}

