/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ArithmeticExpression10
extends BinaryExpression {
    private Calculator calculator;

    public ArithmeticExpression10(Expression p0, int operator, Expression p1) {
        super(p0, operator, p1);
    }

    public boolean isBackwardsCompatible() {
        return true;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (Literal.isEmptySequence(this.operand0)) {
            return new Literal(DoubleValue.NaN);
        }
        if (Literal.isEmptySequence(this.operand1)) {
            return new Literal(DoubleValue.NaN);
        }
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        SequenceType atomicType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        role0.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, true, role0, visitor);
        ItemType itemType0 = this.operand0.getItemType(th);
        if (itemType0 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(DoubleValue.NaN);
        }
        AtomicType type0 = (AtomicType)itemType0.getPrimitiveItemType();
        if (this.calculator == null) {
            this.operand0 = this.createConversionCode(this.operand0, th, type0);
        }
        type0 = (AtomicType)this.operand0.getItemType(th).getPrimitiveItemType();
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        role1.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, true, role1, visitor);
        ItemType itemType1 = this.operand1.getItemType(th);
        if (itemType1 instanceof EmptySequenceTest) {
            return Literal.makeLiteral(DoubleValue.NaN);
        }
        AtomicType type1 = (AtomicType)itemType1.getPrimitiveItemType();
        if (this.calculator == null) {
            this.operand1 = this.createConversionCode(this.operand1, th, type1);
        }
        type1 = (AtomicType)this.operand1.getItemType(th).getPrimitiveItemType();
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        if (this.operator == 199) {
            Value v;
            if (this.operand1 instanceof Literal && (v = ((Literal)this.operand1).getValue()) instanceof NumericValue) {
                return Literal.makeLiteral(((NumericValue)v).negate());
            }
            NegateExpression ne = new NegateExpression(this.operand1);
            ne.setBackwardsCompatible(true);
            return visitor.typeCheck(ne, contextItemType);
        }
        boolean mustResolve = !type0.equals(BuiltInAtomicType.ANY_ATOMIC) && !type1.equals(BuiltInAtomicType.ANY_ATOMIC);
        this.calculator = Calculator.getCalculator(type0.getFingerprint(), type1.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), mustResolve);
        if (this.calculator == null) {
            XPathException de = new XPathException("Arithmetic operator is not defined for arguments of types (" + type0.getDescription() + ", " + type1.getDescription() + ")");
            de.setLocator(this);
            de.setErrorCode("XPTY0004");
            throw de;
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    private Expression createConversionCode(Expression operand, TypeHierarchy th, AtomicType type) {
        if (Cardinality.allowsMany(operand.getCardinality())) {
            FirstItemExpression fie = new FirstItemExpression(operand);
            ExpressionTool.copyLocationInfo(this, fie);
            operand = fie;
        }
        if (th.isSubType(type, BuiltInAtomicType.DOUBLE) || th.isSubType(type, BuiltInAtomicType.DATE) || th.isSubType(type, BuiltInAtomicType.TIME) || th.isSubType(type, BuiltInAtomicType.DATE_TIME) || th.isSubType(type, BuiltInAtomicType.DURATION)) {
            return operand;
        }
        if (th.isSubType(type, BuiltInAtomicType.BOOLEAN) || th.isSubType(type, BuiltInAtomicType.STRING) || th.isSubType(type, BuiltInAtomicType.UNTYPED_ATOMIC) || th.isSubType(type, BuiltInAtomicType.FLOAT) || th.isSubType(type, BuiltInAtomicType.DECIMAL)) {
            if (operand instanceof Literal) {
                Value val = ((Literal)operand).getValue();
                return new Literal(NumberFn.convert((AtomicValue)val));
            }
            return SystemFunction.makeSystemFunction("number", new Expression[]{operand});
        }
        LetExpression let = new LetExpression();
        let.setRequiredType(SequenceType.OPTIONAL_ATOMIC);
        let.setVariableQName(new StructuredQName("nn", "http://saxon.sf.net/", "nn" + let.hashCode()));
        let.setSequence(operand);
        LocalVariableReference var = new LocalVariableReference(let);
        InstanceOfExpression isDouble = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.DOUBLE, 24576));
        var = new LocalVariableReference(let);
        InstanceOfExpression isDecimal = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.DECIMAL, 24576));
        var = new LocalVariableReference(let);
        InstanceOfExpression isFloat = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.FLOAT, 24576));
        var = new LocalVariableReference(let);
        InstanceOfExpression isString = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.STRING, 24576));
        var = new LocalVariableReference(let);
        InstanceOfExpression isUntypedAtomic = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.UNTYPED_ATOMIC, 24576));
        var = new LocalVariableReference(let);
        InstanceOfExpression isBoolean = new InstanceOfExpression(var, SequenceType.makeSequenceType(BuiltInAtomicType.BOOLEAN, 24576));
        BooleanExpression condition = new BooleanExpression(isDouble, 9, isDecimal);
        condition = new BooleanExpression(condition, 9, isFloat);
        condition = new BooleanExpression(condition, 9, isString);
        condition = new BooleanExpression(condition, 9, isUntypedAtomic);
        condition = new BooleanExpression(condition, 9, isBoolean);
        var = new LocalVariableReference(let);
        NumberFn fn = (NumberFn)SystemFunction.makeSystemFunction("number", new Expression[]{var});
        var = new LocalVariableReference(let);
        var.setStaticType(SequenceType.SINGLE_ATOMIC, null, 0);
        Expression action = Choose.makeConditional(condition, fn, var);
        let.setAction(action);
        return let;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType t2;
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType t1 = this.operand0.getItemType(th);
        if (!(t1 instanceof AtomicType)) {
            t1 = t1.getAtomizedItemType();
        }
        if (!((t2 = this.operand1.getItemType(th)) instanceof AtomicType)) {
            t2 = t2.getAtomizedItemType();
        }
        return this.calculator.getResultType((AtomicType)t1.getPrimitiveItemType(), (AtomicType)t2.getPrimitiveItemType());
    }

    public Expression copy() {
        ArithmeticExpression10 a2 = new ArithmeticExpression10(this.operand0.copy(), this.operator, this.operand1.copy());
        a2.calculator = this.calculator;
        return a2;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue v1 = (AtomicValue)this.operand0.evaluateItem(context);
        if (v1 == null) {
            return DoubleValue.NaN;
        }
        AtomicValue v2 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v2 == null) {
            return DoubleValue.NaN;
        }
        return this.calculator.compute(v1, v2, context);
    }
}

