/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;
import com.sun.star.wizards.form.DataEntrySetter;
import com.sun.star.wizards.form.FieldLinker;
import com.sun.star.wizards.form.FormConfiguration;
import com.sun.star.wizards.form.FormControlArranger;
import com.sun.star.wizards.form.StyleApplier;
import com.sun.star.wizards.form.UIControlArranger;
import com.sun.star.wizards.text.TextDocument;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.ViewHandler;
import java.util.Vector;

public class FormDocument
extends TextDocument {
    protected Vector oControlForms = new Vector();
    protected CommandMetaData oMainFormDBMetaData;
    protected CommandMetaData oSubFormDBMetaData;
    protected String[][] LinkFieldNames;
    private FormHandler oFormHandler;
    private ViewHandler oViewHandler;
    private TextStyleHandler oTextStyleHandler;
    private XPropertySet xPropPageStyle;
    private final int SOFORMGAP = 2000;
    private boolean bhasSubForm;
    private UIControlArranger curUIControlArranger;
    private StyleApplier curStyleApplier;
    private int nPageWidth;
    private int nPageHeight;
    private int nFormWidth;
    private int nFormHeight;
    private Point aMainFormPoint;
    private static final String SOMAINFORM = "MainForm";
    private static final String SOSUBFORM = "SubForm";

    public FormDocument(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory, new TextDocument.ModuleIdentifier("com.sun.star.sdb.FormDesign"), true);
        try {
            this.oFormHandler = new FormHandler(xMultiServiceFactory, this.xTextDocument);
            this.oFormHandler.setDrawObjectsCaptureMode(false);
            this.oTextStyleHandler = new TextStyleHandler(this.xMSFDoc, this.xTextDocument);
            this.oViewHandler = new ViewHandler(this.xMSFDoc, this.xTextDocument);
            this.oMainFormDBMetaData = new CommandMetaData(xMultiServiceFactory);
            this.oSubFormDBMetaData = new CommandMetaData(xMultiServiceFactory);
            ViewHandler viewHandler = new ViewHandler(xMultiServiceFactory, this.xTextDocument);
            TextStyleHandler textStyleHandler = new TextStyleHandler(this.xMSFDoc, this.xTextDocument);
            Helper.setUnoPropertyValue(this.xTextDocument, "ApplyFormDesignMode", Boolean.FALSE);
            viewHandler.setViewSetting("ShowTableBoundaries", Boolean.FALSE);
            viewHandler.setViewSetting("ShowOnlineLayout", Boolean.TRUE);
            this.xPropPageStyle = textStyleHandler.getStyleByName("PageStyles", "Standard");
            Size size = this.oTextStyleHandler.changePageAlignment(this.xPropPageStyle, true);
            this.nPageWidth = size.Width;
            this.nPageHeight = size.Height;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void addUIFormController(UIControlArranger uIControlArranger) {
        this.curUIControlArranger = uIControlArranger;
    }

    public void addStyleApplier(StyleApplier styleApplier) {
        this.curStyleApplier = styleApplier;
    }

    private String getDataSourceName() {
        return this.oMainFormDBMetaData.DataSourceName;
    }

    private void adjustPageStyle() {
        try {
            int n = this.getMainFieldCount() + this.getSubFieldCount();
            int n2 = n > 30 ? 500 : (n > 20 ? 750 : 1000);
            this.xPropPageStyle.setPropertyValue("RightMargin", (Object)new Integer(n2));
            this.xPropPageStyle.setPropertyValue("LeftMargin", (Object)new Integer(n2));
            this.xPropPageStyle.setPropertyValue("TopMargin", (Object)new Integer(n2));
            this.xPropPageStyle.setPropertyValue("BottomMargin", (Object)new Integer(n2));
            this.aMainFormPoint = new Point(n2, n2);
            this.nFormWidth = (int)(0.8 * (double)this.nPageWidth) - 2 * n2;
            this.nFormHeight = (int)(0.65 * (double)this.nPageHeight) - 2 * n2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void initialize(boolean bl, boolean bl2, boolean bl3, Short s) {
        ControlForm controlForm;
        this.bhasSubForm = bl2;
        this.adjustPageStyle();
        if (bl) {
            if (this.oControlForms.size() == 0) {
                controlForm = new ControlForm(this, SOMAINFORM, this.aMainFormPoint, this.getMainFormSize(3));
                this.oControlForms.addElement(controlForm);
            } else {
                this.oFormHandler.removeControlsofForm(SOMAINFORM);
                ((ControlForm)this.oControlForms.get((int)0)).oFormController = null;
            }
            ((ControlForm)this.oControlForms.get(0)).initialize(this.curUIControlArranger.getSelectedArrangement(0), s);
        }
        if (bl2) {
            if (this.oControlForms.size() == 1) {
                this.adjustMainFormSize(s);
                controlForm = new ControlForm(this, SOSUBFORM, this.getSubFormPoint(), this.getSubFormSize());
                this.oControlForms.addElement(controlForm);
                controlForm.initialize(this.curUIControlArranger.getSelectedArrangement(1), s);
            } else if (bl3 && this.oControlForms.size() > 1) {
                this.oFormHandler.removeControlsofForm(SOSUBFORM);
                ((ControlForm)this.oControlForms.get((int)1)).oFormController = null;
                ((ControlForm)this.oControlForms.get(1)).initialize(this.curUIControlArranger.getSelectedArrangement(1), s);
            }
        } else {
            controlForm = (ControlForm)this.oControlForms.get(0);
            if (controlForm.xFormContainer != null && controlForm.xFormContainer.hasByName(SOSUBFORM)) {
                this.oFormHandler.removeControlsofForm(SOSUBFORM);
                this.oFormHandler.removeElement(controlForm.xFormContainer, SOSUBFORM);
                ((ControlForm)this.oControlForms.get((int)1)).oFormController = null;
                this.oControlForms.remove(1);
                this.adjustMainFormSize(s);
            }
        }
    }

    private int getMainFieldCount() {
        return this.oMainFormDBMetaData.getFieldNames().length;
    }

    private int getSubFieldCount() {
        return this.oSubFormDBMetaData.getFieldNames().length;
    }

    private Size getMainFormSize(int n) {
        int n2 = this.nFormHeight;
        if (this.bhasSubForm) {
            if (n == 3) {
                n2 = (int)((double)(this.nFormHeight - 2000) / 2.0);
            } else {
                int n3 = this.getMainFieldCount() + this.getSubFieldCount();
                n2 = (int)((double)this.getMainFieldCount() / (double)n3 * ((double)(this.nFormHeight - 2000) / 2.0));
            }
        }
        return new Size(this.nFormWidth, n2);
    }

    private Size getSubFormSize() {
        int n = ((ControlForm)this.oControlForms.get(0)).getActualFormHeight();
        return new Size(this.nFormWidth, this.nFormHeight - n - 2000);
    }

    private Point getSubFormPoint() {
        ControlForm controlForm = (ControlForm)this.oControlForms.get(0);
        return new Point(controlForm.aStartPoint.X, controlForm.aStartPoint.Y + controlForm.getFormSize().Height + 2000);
    }

    private void adjustMainFormSize(Short s) {
        ControlForm controlForm = (ControlForm)this.oControlForms.get(0);
        controlForm.setFormSize(this.getMainFormSize(controlForm.curArrangement));
        if (controlForm.curArrangement == 3) {
            controlForm.oGridControl.setSize(controlForm.getFormSize());
        } else {
            controlForm.oFormController.positionControls(controlForm.curArrangement, controlForm.aStartPoint, controlForm.getFormSize(), this.curUIControlArranger.getAlignValue(), s);
        }
    }

    private void adjustSubFormPosSize(Short s) {
        ControlForm controlForm = (ControlForm)this.oControlForms.get(0);
        ControlForm controlForm2 = (ControlForm)this.oControlForms.get(1);
        controlForm2.setFormSize(new Size(this.nFormWidth, this.nFormHeight - controlForm.getFormSize().Height));
        if (controlForm2.curArrangement == 3) {
            Point point = controlForm2.oGridControl.getPosition();
            int n = controlForm2.getEntryPointY() - controlForm.getActualFormHeight() - controlForm.aStartPoint.Y - 2000;
            controlForm2.setStartPoint(new Point(point.X, point.Y - n));
            controlForm2.oGridControl.setPosition(controlForm2.aStartPoint);
            controlForm2.oGridControl.setSize(this.getSubFormSize());
        } else {
            controlForm2.setStartPoint(new Point(controlForm2.aStartPoint.X, controlForm.getActualFormHeight() + controlForm.aStartPoint.Y + 2000));
            controlForm2.oFormController.positionControls(controlForm2.curArrangement, controlForm2.aStartPoint, controlForm2.getAvailableFormSize(), this.curUIControlArranger.getAlignValue(), s);
        }
    }

    public ControlForm getControlFormByName(String string) {
        for (int i = 0; i < this.oControlForms.size(); ++i) {
            ControlForm controlForm = (ControlForm)this.oControlForms.get(i);
            if (!controlForm.Name.equals(string)) continue;
            return controlForm;
        }
        return null;
    }

    public ControlForm[] getControlForms() {
        ControlForm[] controlFormArray = new ControlForm[this.oControlForms.size()];
        this.oControlForms.toArray(controlFormArray);
        return controlFormArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finalizeForms(DataEntrySetter dataEntrySetter, FieldLinker fieldLinker, FormConfiguration formConfiguration) {
        try {
            this.xTextDocument.lockControllers();
            PropertyValue[] propertyValueArray = dataEntrySetter.getFormProperties();
            ControlForm controlForm = this.getControlFormByName(SOMAINFORM);
            controlForm.setFormProperties(propertyValueArray, this.oMainFormDBMetaData);
            controlForm.finalizeControls();
            if (controlForm.xFormContainer.hasByName(SOSUBFORM)) {
                ControlForm controlForm2 = this.getControlFormByName(SOSUBFORM);
                controlForm2.setFormProperties(propertyValueArray, this.oSubFormDBMetaData);
                String string = formConfiguration.getreferencedTableName();
                this.LinkFieldNames = string.equals(PropertyNames.EMPTY_STRING) ? fieldLinker.getLinkFieldNames() : fieldLinker.getLinkFieldNames(formConfiguration.getRelationController(), string);
                if (this.LinkFieldNames != null && this.LinkFieldNames.length > 0) {
                    controlForm2.xPropertySet.setPropertyValue("DetailFields", (Object)this.LinkFieldNames[0]);
                    controlForm2.xPropertySet.setPropertyValue("MasterFields", (Object)this.LinkFieldNames[1]);
                    controlForm2.finalizeControls();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockallControllers();
        }
    }

    public class ControlForm {
        XNameContainer xFormContainer;
        GridControl oGridControl;
        FormControlArranger oFormController;
        int curArrangement;
        FormDocument oFormDocument;
        String Name;
        Point aStartPoint;
        private Size aFormSize;
        CommandMetaData oDBMetaData;
        XPropertySet xPropertySet;

        public ControlForm(FormDocument formDocument2, String string, Point point, Size size) {
            this.aStartPoint = point;
            this.aFormSize = size;
            this.oFormDocument = formDocument2;
            this.Name = string;
            if (string.equals(FormDocument.SOSUBFORM)) {
                ControlForm controlForm = (ControlForm)FormDocument.this.oControlForms.get(0);
                this.xFormContainer = FormDocument.this.oFormHandler.insertFormbyName(string, controlForm.xFormContainer);
            } else {
                this.xFormContainer = FormDocument.this.oFormHandler.insertFormbyName(string);
            }
            this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xFormContainer);
            this.oDBMetaData = string.equals(FormDocument.SOMAINFORM) ? this.oFormDocument.oMainFormDBMetaData : this.oFormDocument.oSubFormDBMetaData;
        }

        public void initialize(int n, Short s) {
            ControlForm controlForm;
            boolean bl = false;
            FormDocument.this.xTextDocument.lockControllers();
            this.curArrangement = n;
            if (this.oGridControl != null) {
                ((FormDocument)FormDocument.this).oFormHandler.xDrawPage.remove(this.oGridControl.xShape);
                this.oGridControl.xComponent.dispose();
                this.oGridControl = null;
            }
            if (this.oFormController == null) {
                this.oFormController = new FormControlArranger(FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData, FormDocument.this.xProgressBar, this.aStartPoint, this.aFormSize);
            } else if (this.curArrangement == 3) {
                FormDocument.this.oFormHandler.moveShapesToNirwana(this.getLabelControls());
                FormDocument.this.oFormHandler.moveShapesToNirwana(this.getDatabaseControls());
            }
            if (this.curArrangement == 3) {
                this.insertGridControl(s);
                bl = true;
            } else {
                bl = !this.oFormController.areControlsexisting();
                this.oFormController.positionControls(n, this.aStartPoint, this.getAvailableFormSize(), FormDocument.this.curUIControlArranger.getAlignValue(), s);
            }
            if (bl) {
                FormDocument.this.curStyleApplier.applyStyle(false, true);
            }
            if (this.Name.equals(FormDocument.SOMAINFORM) && FormDocument.this.oControlForms.size() > 1 && (controlForm = (ControlForm)FormDocument.this.oControlForms.get(1)) != null) {
                FormDocument.this.adjustSubFormPosSize(s);
            }
            this.setFormSize(new Size(this.aFormSize.Width, this.getActualFormHeight()));
            FormDocument.this.unlockallControllers();
        }

        public Control[] getLabelControls() {
            if (this.oFormController != null) {
                return this.oFormController.getLabelControlList();
            }
            return null;
        }

        public Size getFormSize() {
            return this.aFormSize;
        }

        private Size getAvailableFormSize() {
            if (this.Name.equals(FormDocument.SOMAINFORM)) {
                this.setFormSize(FormDocument.this.getMainFormSize(this.curArrangement));
            } else {
                this.setFormSize(FormDocument.this.getSubFormSize());
            }
            return this.aFormSize;
        }

        public void setFormSize(Size size) {
            this.aFormSize = size;
            this.oFormController.setFormSize(this.aFormSize);
        }

        private void setStartPoint(Point point) {
            this.aStartPoint = point;
            if (this.oFormController != null) {
                this.oFormController.setStartPoint(point);
            }
        }

        private int getActualFormHeight() {
            if (this.curArrangement == 3) {
                return this.oGridControl.xShape.getSize().Height;
            }
            return this.oFormController.getFormHeight();
        }

        private int getEntryPointY() {
            if (this.curArrangement == 3) {
                return this.oGridControl.xShape.getPosition().Y;
            }
            return this.oFormController.getEntryPointY();
        }

        private void setFormProperties(PropertyValue[] propertyValueArray, CommandMetaData commandMetaData) {
            try {
                this.xPropertySet.setPropertyValue("DataSourceName", (Object)FormDocument.this.getDataSourceName());
                this.xPropertySet.setPropertyValue(PropertyNames.COMMAND, (Object)commandMetaData.getCommandName());
                this.xPropertySet.setPropertyValue(PropertyNames.COMMAND_TYPE, (Object)new Integer(commandMetaData.getCommandType()));
                for (int i = 0; i < propertyValueArray.length; ++i) {
                    this.xPropertySet.setPropertyValue(propertyValueArray[i].Name, propertyValueArray[i].Value);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public DatabaseControl[] getDatabaseControls() {
            if (this.oFormController != null) {
                return this.oFormController.DBControlList;
            }
            return null;
        }

        public GridControl getGridControl() {
            return this.oGridControl;
        }

        public int getArrangemode() {
            return this.curArrangement;
        }

        private void insertGridControl(Short s) {
            try {
                this.curArrangement = 3;
                this.oGridControl = this.Name.equals(FormDocument.SOMAINFORM) ? new GridControl(FormDocument.this.xMSF, this.Name + "_Grid", FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData.FieldColumns, this.aStartPoint, FormDocument.this.getMainFormSize(3)) : new GridControl(FormDocument.this.xMSF, this.Name + "_Grid", FormDocument.this.oFormHandler, this.xFormContainer, this.oDBMetaData.FieldColumns, this.aStartPoint, FormDocument.this.getSubFormSize());
                this.oGridControl.xPropertySet.setPropertyValue(PropertyNames.PROPERTY_BORDER, (Object)s);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void finalizeControls() {
            Control[] controlArray = this.getLabelControls();
            DatabaseControl[] databaseControlArray = this.getDatabaseControls();
            if (controlArray != null) {
                for (int i = 0; i < this.getLabelControls().length; ++i) {
                    if (this.curArrangement == 3) {
                        if (controlArray[i] == null || databaseControlArray[i] == null) continue;
                        FormDocument.this.oFormHandler.removeShape(controlArray[i].xShape);
                        FormDocument.this.oFormHandler.removeShape(databaseControlArray[i].xShape);
                        continue;
                    }
                    FormDocument.this.oFormHandler.groupShapesTogether(FormDocument.this.xMSF, controlArray[i].xShape, databaseControlArray[i].xShape);
                }
            }
        }
    }
}

