/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.test;

import cpdetector.io.UnknownCharset;
import cpdetector.util.FileUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class EncodingRepository {
    private static EncodingRepository instance = null;
    private Set scannedDirs = new TreeSet();
    private Map url2encoding = new HashMap();

    private EncodingRepository() {
    }

    public static EncodingRepository getInstance() {
        if (instance == null) {
            instance = new EncodingRepository();
        }
        return instance;
    }

    public Charset getVerifiedEncoding(URL document) throws IOException {
        String enc;
        Charset ret = null;
        Map.Entry dirSep = FileUtil.cutDirectoryInformation(document);
        if (!this.scannedDirs.contains(dirSep.getKey())) {
            this.parseVerfificationFile(new URL(dirSep.getKey().toString()));
            this.scannedDirs.add(dirSep.getKey().toString());
        }
        ret = (enc = (String)this.url2encoding.get(document.toExternalForm().toLowerCase())) == null ? UnknownCharset.getInstance() : Charset.forName(enc);
        return ret;
    }

    private void parseVerfificationFile(URL dir) throws IOException {
        System.out.println("Trying to load encoding.verify from: " + dir.toExternalForm());
        URL load = new URL(dir, "encoding.verify");
        Properties props = new Properties();
        try {
            props.load(load.openStream());
            Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String url = new URL(dir, entry.getKey().toString()).toExternalForm();
                String encoding = entry.getValue().toString().trim();
                System.out.println("key: " + url + "\nvalue  " + encoding);
                this.url2encoding.put(url.toLowerCase(), encoding);
            }
        }
        catch (IOException ioex) {
            throw new IOException("Unable to verify the character encodings for documents under: " + dir.toExternalForm() + ". Missing file: encoding.verify");
        }
    }
}

