/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CellStyle
extends Style
implements Cloneable {
    private Format fmt = new Format();
    private static String[] ignored = new String[]{"style:text-autospace", "style:text-underline-color", "fo:margin-left", "fo:margin-right", "fo:text-indent", "fo:margin-top", "fo:margin-bottom", "text:line-number", "text:number-lines", "style:country-asian", "style:font-size-asian", "style:font-name-complex", "style:language-complex", "style:country-complex", "style:font-size-complex", "style:punctuation-wrap", "fo:language", "fo:country", "style:font-name-asian", "style:language-asian", "style:line-break", "fo:keep-with-next"};

    public CellStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                this.handleAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NamedNodeMap namedNodeMap2;
                Node node3 = nodeList.item(i);
                String string = node3.getNodeName();
                if (!string.equals("style:properties") || (namedNodeMap2 = node3.getAttributes()) == null) continue;
                int n3 = namedNodeMap2.getLength();
                for (int j = 0; j < n3; ++j) {
                    Node node4 = namedNodeMap2.item(j);
                    this.handleAttribute(node4.getNodeName(), node4.getNodeValue());
                }
            }
        }
    }

    public CellStyle(String string, String string2, String string3, Format format, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        this.fmt = format;
    }

    public Format getFormat() {
        return this.fmt;
    }

    private Color parseColorString(String string) {
        String string2 = string.substring(1, 3);
        String string3 = string.substring(3, 5);
        String string4 = string.substring(5, 7);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string2, 16);
            n2 = Integer.parseInt(string3, 16);
            n3 = Integer.parseInt(string4, 16);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.log(2, "Problem parsing a color string", numberFormatException);
        }
        return new Color(n, n2, n3, 0);
    }

    private void handleAttribute(String string, String string2) {
        if (string.equals("fo:font-weight")) {
            this.fmt.setAttribute(1, string2.equals("bold"));
        } else if (string.equals("fo:font-style")) {
            if (string2.equals("italic") || string2.equals("oblique")) {
                this.fmt.setAttribute(2, true);
            } else if (string2.equals("normal")) {
                this.fmt.setAttribute(2, false);
            }
        } else if (string.equals("style:text-underline")) {
            this.fmt.setAttribute(4, !string2.equals("none"));
        } else if (string.equals("style:text-crossing-out")) {
            this.fmt.setAttribute(8, !string2.equals("none"));
        } else if (string.equals("style:text-position")) {
            if (string2.startsWith("super ")) {
                this.fmt.setAttribute(16, true);
            } else if (string2.startsWith("sub ")) {
                this.fmt.setAttribute(32, true);
            } else if (string2.startsWith("0% ")) {
                this.fmt.setAttribute(48, false);
            } else {
                String string3 = string2.substring(0, string2.indexOf(" "));
                if (string3.endsWith("%")) {
                    int n;
                    string3 = string3.substring(0, string2.indexOf("%"));
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                        Debug.log(2, "Problem with style:text-position tag", numberFormatException);
                    }
                    if (n < 0) {
                        this.fmt.setAttribute(32, true);
                    } else if (n > 0) {
                        this.fmt.setAttribute(16, false);
                    }
                }
            }
        } else if (string.equals("fo:font-size")) {
            if (string2.endsWith("pt")) {
                String string4 = string2.substring(0, string2.length() - 2);
                this.fmt.setFontSize(Integer.parseInt(string4));
            }
        } else if (string.equals("style:font-name")) {
            this.fmt.setFontName(string2);
        } else if (string.equals("fo:color")) {
            this.fmt.setForeground(this.parseColorString(string2));
        } else if (string.equals("fo:background-color")) {
            this.fmt.setBackground(this.parseColorString(string2));
        } else if (string.equals("fo:text-align")) {
            if (string2.equals("center")) {
                this.fmt.setAlign(2);
            } else if (string2.equals("end")) {
                this.fmt.setAlign(1);
            } else if (string2.equals("start")) {
                this.fmt.setAlign(3);
            }
        } else if (string.equals("fo:vertical-align")) {
            if (string2.equals("top")) {
                this.fmt.setVertAlign(1);
            } else if (string2.equals("middle")) {
                this.fmt.setVertAlign(2);
            } else if (string2.equals("bottom")) {
                this.fmt.setVertAlign(3);
            }
        } else if (string.equals("fo:border")) {
            this.fmt.setAttribute(256, !string2.equals("none"));
            this.fmt.setAttribute(512, !string2.equals("none"));
            this.fmt.setAttribute(64, !string2.equals("none"));
            this.fmt.setAttribute(128, !string2.equals("none"));
        } else if (string.equals("fo:border-top")) {
            this.fmt.setAttribute(256, !string2.equals("none"));
        } else if (string.equals("fo:border-bottom")) {
            this.fmt.setAttribute(512, !string2.equals("none"));
        } else if (string.equals("fo:border-left")) {
            this.fmt.setAttribute(64, !string2.equals("none"));
        } else if (string.equals("fo:border-right")) {
            this.fmt.setAttribute(128, !string2.equals("none"));
        } else if (string.equals("fo:wrap-option")) {
            this.fmt.setAttribute(1024, string2.equals("wrap"));
        } else if (!this.isIgnored(string)) {
            Debug.log(1, "CellStyle Unhandled: " + string + "=" + string2);
        }
    }

    @Override
    public Style getResolved() {
        CellStyle cellStyle = null;
        try {
            cellStyle = (CellStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        CellStyle cellStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                cellStyle2 = (CellStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (cellStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    cellStyle2 = (CellStyle)cellStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                cellStyle2 = (CellStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (cellStyle2 != null) {
            cellStyle2 = (CellStyle)cellStyle2.getResolved();
            Format format = cellStyle2.getFormat();
            Format format2 = cellStyle.getFormat();
            if (this.fmt.getAlign() == 3 && format.getAlign() != 3) {
                format2.setAlign(format.getAlign());
            }
            if (this.fmt.getVertAlign() == 3 && format.getVertAlign() != 3) {
                format2.setVertAlign(format.getVertAlign());
            }
            if (this.fmt.getFontSize() == 0 && format.getFontSize() != 0) {
                format2.setFontSize(format.getFontSize());
            }
            if (this.fmt.getFontName() == null && format.getFontName() != null) {
                format2.setFontName(format.getFontName());
            }
            if (this.fmt.getForeground() == null && format.getForeground() != null) {
                format2.setForeground(format.getForeground());
            }
            if (this.fmt.getBackground() == null && format.getBackground() != null) {
                format2.setBackground(format.getBackground());
            }
            for (int i = 1; i <= 32; i <<= 1) {
                if (!this.fmt.getAttribute(i) || !format.getAttribute(i)) continue;
                format2.setAttribute(i, format.getAttribute(i));
            }
        }
        return cellStyle;
    }

    @Override
    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    @Override
    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        CellStyle cellStyle = (CellStyle)style;
        Format format = cellStyle.getFormat();
        return this.fmt.isSubset(format);
    }

    public void writeAttributes(Element element) {
        if (this.fmt.getAlign() == 1) {
            element.setAttribute("fo:text-align", "end");
        }
        if (this.fmt.getAlign() == 3) {
            element.setAttribute("fo:text-align", "start");
        }
        if (this.fmt.getAlign() == 2) {
            element.setAttribute("fo:text-align", "center");
        }
        if (this.fmt.getVertAlign() == 1) {
            element.setAttribute("fo:vertical-align", "top");
        }
        if (this.fmt.getVertAlign() == 2) {
            element.setAttribute("fo:vertical-align", "middle");
        }
        if (this.fmt.getVertAlign() == 3) {
            element.setAttribute("fo:vertical-align", "bottom");
        }
        if (this.fmt.getAttribute(1)) {
            element.setAttribute("fo:font-weight", "bold");
        }
        if (this.fmt.getAttribute(2)) {
            element.setAttribute("fo:font-style", "italic");
        }
        if (this.fmt.getAttribute(4)) {
            element.setAttribute("style:text-underline", "single");
        }
        if (this.fmt.getAttribute(8)) {
            element.setAttribute("style:text-crossing-out", "single-line");
        }
        if (this.fmt.getAttribute(16)) {
            element.setAttribute("style:text-position", "super 58%");
        }
        if (this.fmt.getAttribute(32)) {
            element.setAttribute("style:text-position", "sub 58%");
        }
        if (this.fmt.getFontSize() != 0) {
            Integer n = new Integer(this.fmt.getFontSize());
            element.setAttribute("fo:font-size", n.toString() + "pt");
        }
        if (this.fmt.getFontName() != null) {
            element.setAttribute("style:font-name", this.fmt.getFontName());
        }
        if (this.fmt.getForeground() != null) {
            element.setAttribute("fo:color", this.buildColorString(this.fmt.getForeground()));
        }
        if (this.fmt.getBackground() != null) {
            element.setAttribute("fo:background-color", this.buildColorString(this.fmt.getBackground()));
        }
        if (this.fmt.getAttribute(256)) {
            element.setAttribute("fo:border-top", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(512)) {
            element.setAttribute("fo:border-bottom", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(128)) {
            element.setAttribute("fo:border-right", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(64)) {
            element.setAttribute("fo:border-left", "0.0008inch solid #000000");
        }
        if (this.fmt.getAttribute(1024)) {
            element.setAttribute("fo:wrap-option", "wrap");
        }
    }

    private String buildColorString(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        String string = new String("#");
        for (int i = 0; i <= 2; ++i) {
            String string2 = Integer.toHexString(nArray[i]);
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            string = string + string2;
        }
        return string;
    }

    private boolean isIgnored(String string) {
        for (int i = 0; i < ignored.length; ++i) {
            if (!ignored[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

