/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.canvas;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openoffice.accessibility.awb.canvas.Canvas;

class CanvasShape
implements XAccessibleEventListener {
    public final Color maHighlightColor = Color.red;
    public final Color maSelectionColor = Color.green;
    public final Color maFocusColor = Color.blue;
    private Canvas maCanvas;
    private TreeNode maNode;
    private XAccessibleContext mxContext;
    private XAccessibleComponent mxComponent;
    private String msDescription;
    private String msName;
    private Rectangle2D.Double maShape;
    private AffineTransform maTransformation;
    private java.awt.Point maPosition;
    private Dimension maTransformedSize;
    private Dimension maSize;
    private Color maFgColor;
    private Color maBgColor;
    private boolean mbHighlighted;
    private boolean mbSelected;
    private boolean mbFocused;
    private int mnRole;

    public CanvasShape(TreeNode treeNode, Canvas canvas) {
        this.maNode = treeNode;
        this.msName = "<no name>";
        this.msDescription = "<no description>";
        this.maShape = new Rectangle2D.Double(-10.0, -10.0, 10.0, 10.0);
        this.maPosition = new java.awt.Point(-10, -10);
        this.maSize = new Dimension(10, 10);
        this.maFgColor = Color.black;
        this.maBgColor = Color.blue;
        this.mnRole = -1;
        this.mbHighlighted = false;
        this.mbSelected = false;
        this.mbFocused = false;
        this.maCanvas = canvas;
        this.Update();
    }

    public TreePath getNodePath(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.getParent();
        return treeNode2 != null ? this.getNodePath(treeNode2).pathByAddingChild(treeNode) : new TreePath(treeNode);
    }

    public TreePath getNodePath() {
        return this.getNodePath(this.maNode);
    }

    public void Update() {
        Color color;
        if (this.maNode instanceof XAccessible) {
            this.mxContext = ((XAccessible)this.maNode).getAccessibleContext();
            this.mxComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.mxContext);
        }
        if (this.mxContext != null) {
            this.msName = this.mxContext.getAccessibleName();
            this.msDescription = this.mxContext.getAccessibleDescription();
            this.mnRole = this.mxContext.getAccessibleRole();
            color = this.mxContext.getAccessibleStateSet();
            if (color != null) {
                this.mbSelected = color.contains((short)23);
                this.mbFocused = color.contains((short)11);
            }
        }
        this.UpdateGeometry();
        if (this.mxComponent != null) {
            color = new Color(this.mxComponent.getForeground(), true);
            this.maFgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - color.getAlpha());
            color = new Color(this.mxComponent.getBackground(), true);
            this.maBgColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - color.getAlpha());
        }
    }

    public void UpdateGeometry() {
        if (this.mxComponent != null) {
            Point point = this.mxComponent.getLocationOnScreen();
            Size size = this.mxComponent.getSize();
            this.maPosition = new java.awt.Point(point.X, point.Y);
            this.maSize = new Dimension(size.Width, size.Height);
        }
    }

    public void paint(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n;
            int n2;
            java.awt.Point point = new java.awt.Point();
            this.maShape = new Rectangle2D.Double(this.maPosition.x, this.maPosition.y, this.maSize.width, this.maSize.height);
            this.maTransformation = graphics2D.getTransform();
            if (this.mxContext.getAccessibleChildCount() == 0) {
                graphics2D.setColor(this.maBgColor);
                graphics2D.fill(this.maShape);
            }
            Color color = this.maFgColor;
            if (this.maFgColor.getAlpha() < 128) {
                color = new Color(this.maFgColor.getRed(), this.maFgColor.getGreen(), this.maFgColor.getBlue());
            }
            graphics2D.setColor(color);
            graphics2D.draw(this.maShape);
            if (this.mbFocused) {
                graphics2D.setColor(this.maFocusColor);
                for (n2 = 0; n2 <= 2; ++n2) {
                    for (n = 0; n <= 2; ++n) {
                        graphics2D.fill(new Rectangle2D.Double(this.maShape.x + (double)n2 / 2.0 * this.maShape.width - 3.0, this.maShape.y + (double)n / 2.0 * this.maShape.height - 3.0, 6.0, 6.0));
                    }
                }
            }
            if (this.mbSelected) {
                graphics2D.setColor(this.maSelectionColor);
                for (n2 = 0; n2 <= 2; ++n2) {
                    for (n = 0; n <= 2; ++n) {
                        graphics2D.draw(new Rectangle2D.Double(this.maShape.x + (double)n2 / 2.0 * this.maShape.width - 2.0, this.maShape.y + (double)n / 2.0 * this.maShape.height - 2.0, 4.0, 4.0));
                    }
                }
            }
            graphics2D.setColor(this.maFgColor);
            if (bl2) {
                this.paintName(graphics2D);
            }
            if (bl) {
                this.paintDescription(graphics2D);
            }
            if (bl3) {
                this.paintText(graphics2D);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint_highlight(Graphics2D graphics2D) {
        if (this.mbHighlighted) {
            graphics2D.setColor(this.maHighlightColor);
        } else {
            graphics2D.setColor(this.maFgColor);
        }
        graphics2D.draw(this.maShape);
    }

    private void paintName(Graphics2D graphics2D) {
        graphics2D.drawString("Name: " + this.msName, (float)this.maShape.x + 5.0f, (float)this.maShape.y + 15.0f);
    }

    private void paintDescription(Graphics2D graphics2D) {
        graphics2D.drawString("Description: " + this.msDescription, (float)this.maShape.x + 5.0f, (float)this.maShape.y + 35.0f);
    }

    private void paintText(Graphics2D graphics2D) {
        XAccessibleText xAccessibleText = null;
        xAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.mxContext);
        if (xAccessibleText != null) {
            String string = xAccessibleText.getText();
            try {
                for (int i = 0; i < string.length(); ++i) {
                    Rectangle rectangle = xAccessibleText.getCharacterBounds(i);
                    double d = this.maShape.x + (double)rectangle.X;
                    double d2 = this.maShape.y + (double)rectangle.Y + (double)rectangle.Height;
                    graphics2D.drawString(string.substring(i, i + 1), (float)d, (float)d2);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public boolean Contains(int n, int n2) {
        Point2D.Double double_ = new Point2D.Double(n, n2);
        try {
            this.maTransformation.inverseTransform(double_, double_);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return false;
        }
        return this.maShape.contains(double_);
    }

    public void Highlight(boolean bl) {
        this.mbHighlighted = bl;
    }

    public boolean IsHighlighted() {
        return this.mbHighlighted;
    }

    public java.awt.Rectangle GetBBox() {
        return new java.awt.Rectangle(this.maPosition, this.maSize);
    }

    public java.awt.Point getOrigin() {
        return this.maPosition;
    }

    public Dimension GetSize() {
        return this.maSize;
    }

    public int getRole() {
        return this.mnRole;
    }

    public XAccessibleContext getContext() {
        return this.mxContext;
    }

    public XAccessibleComponent getComponent() {
        return this.mxComponent;
    }

    public String toString() {
        return ">" + this.msName + ", " + this.msDescription + " +" + this.maPosition.x + "+" + this.maPosition.y + "x" + this.maSize.width + "x" + this.maSize.height + "<";
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        try {
            switch (accessibleEventObject.EventId) {
                case 6: 
                case 10: {
                    this.UpdateGeometry();
                    this.maCanvas.repaint();
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.err.println("caught exception while updating a shape:" + exception);
            exception.printStackTrace(System.err);
        }
    }

    public void disposing(EventObject eventObject) {
        System.out.println("Disposing");
    }
}

