/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.tree;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import org.openoffice.accessibility.awb.tree.AccessibilityModel;
import org.openoffice.accessibility.awb.tree.AccessibilityNode;

class DynamicAccessibilityNode
extends AccessibilityNode {
    public DynamicAccessibilityNode(AccessibilityModel accessibilityModel) {
        super(accessibilityModel);
    }

    protected void populate() {
        try {
            XAccessibleContext xAccessibleContext = this.getAccessibleContext();
            if (xAccessibleContext != null) {
                int n = xAccessibleContext.getAccessibleChildCount();
                for (int i = 0; i < n; ++i) {
                    XAccessible xAccessible = xAccessibleContext.getAccessibleChild(i);
                    AccessibilityNode accessibilityNode = this.treeModel.findNode(xAccessible);
                    if (accessibilityNode == null) {
                        accessibilityNode = this.treeModel.createNode(xAccessible);
                    }
                    if (accessibilityNode == null) continue;
                    this.add(accessibilityNode);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void clear() {
        this.removeAllChildren();
    }

    @Override
    public boolean isLeaf() {
        try {
            XAccessibleContext xAccessibleContext = this.getAccessibleContext();
            if (xAccessibleContext != null) {
                return xAccessibleContext.getAccessibleChildCount() == 0;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return true;
        }
    }
}

