/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.uno.UnoRuntime;
import javax.swing.JLabel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;

public class ComponentView
extends ObjectView {
    private XAccessibleComponent mxComponent;
    private JLabel maRelativeLocationLabel;
    private JLabel maAbsoluteLocationLabel;
    private JLabel maSizeLabel;
    private JLabel maBoundingBoxLabel;
    private JLabel maConsistencyLabel;
    private JLabel maForegroundColorLabel;
    private JLabel maBackgroundColorLabel;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext) != null) {
            return new ComponentView(objectViewContainer);
        }
        return null;
    }

    public ComponentView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        ViewGridLayout viewGridLayout = new ViewGridLayout(this);
        this.maRelativeLocationLabel = viewGridLayout.AddLabeledEntry("Relative Location: ");
        this.maAbsoluteLocationLabel = viewGridLayout.AddLabeledEntry("Location on Screen: ");
        this.maSizeLabel = viewGridLayout.AddLabeledEntry("Size");
        this.maBoundingBoxLabel = viewGridLayout.AddLabeledEntry("Bounding Box: ");
        this.maConsistencyLabel = viewGridLayout.AddLabeledEntry("Consistent: ");
        this.maForegroundColorLabel = viewGridLayout.AddLabeledEntry("Foreground Color: ");
        this.maBackgroundColorLabel = viewGridLayout.AddLabeledEntry("Background Color: ");
    }

    @Override
    public void SetObject(XAccessibleContext xAccessibleContext) {
        this.mxComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        super.SetObject(xAccessibleContext);
    }

    @Override
    public void Update() {
        if (this.mxContext == null) {
            this.maRelativeLocationLabel.setText("<null object>");
            this.maAbsoluteLocationLabel.setText("<null object>");
            this.maSizeLabel.setText("<null object>");
            this.maBoundingBoxLabel.setText("<null object>");
            this.maConsistencyLabel.setText("<null object>");
            this.maForegroundColorLabel.setText("<null object>");
            this.maBackgroundColorLabel.setText("<null object>");
        } else {
            XAccessible xAccessible;
            XAccessibleComponent xAccessibleComponent;
            Point point = this.mxComponent.getLocation();
            this.maRelativeLocationLabel.setText(point.X + ", " + point.Y);
            Point point2 = this.mxComponent.getLocationOnScreen();
            this.maAbsoluteLocationLabel.setText(point2.X + ", " + point2.Y);
            Size size = this.mxComponent.getSize();
            this.maSizeLabel.setText(size.Width + ", " + size.Height);
            Rectangle rectangle = this.mxComponent.getBounds();
            this.maBoundingBoxLabel.setText(rectangle.X + ", " + rectangle.Y + "," + rectangle.Width + ", " + rectangle.Height);
            int n = this.mxComponent.getForeground();
            this.maForegroundColorLabel.setText("R" + (n >> 16 & 0xFF) + "G" + (n >> 8 & 0xFF) + "B" + (n >> 0 & 0xFF) + "A" + (n >> 24 & 0xFF));
            n = this.mxComponent.getBackground();
            this.maBackgroundColorLabel.setText("R" + (n >> 16 & 0xFF) + "G" + (n >> 8 & 0xFF) + "B" + (n >> 0 & 0xFF) + "A" + (n >> 24 & 0xFF));
            String string = new String();
            if (rectangle.X != point.X || rectangle.Y != point.Y) {
                string = string + (string.length() != 0 ? ", " : "") + "Bounding box conflicts with relative location";
            }
            if (rectangle.Width != size.Width || rectangle.Height != size.Height) {
                string = string + (string.length() != 0 ? ", " : "") + "Bounding box conflicts with size";
            }
            if ((xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)(xAccessible = this.mxContext.getAccessibleParent()))) == null) {
                if (point.X != point2.X || point.Y != point2.Y) {
                    string = string + (string.length() != 0 ? ", " : "") + "location on screen does not equal " + "relative location without parent";
                }
            } else {
                Point point3 = xAccessibleComponent.getLocationOnScreen();
                if (point.X + point3.X != point2.X || point.Y + point3.Y != point2.Y) {
                    string = string + (string.length() != 0 ? ", " : "") + "location on screen does not match " + "relative location";
                }
            }
            if (string.length() == 0) {
                string = string + "yes";
            } else {
                this.maConsistencyLabel.setBackground(this.GetContainer().GetErrorColor());
            }
            this.maConsistencyLabel.setText(string);
        }
    }

    @Override
    public String GetTitle() {
        return "Component";
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 6: 
            case 10: {
                this.Update();
            }
        }
    }
}

