/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.misc.NameProvider;

class EventMonitorView
extends ObjectView {
    private JTextArea maText;
    private int mnLineNo = 0;
    private JScrollPane maScrollPane;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            return new EventMonitorView(objectViewContainer);
        }
        return null;
    }

    public EventMonitorView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        this.Layout();
    }

    @Override
    public String GetTitle() {
        return "Event Monitor";
    }

    private void Layout() {
        this.setLayout(new GridBagLayout());
        this.maText = new JTextArea();
        this.maText.setBackground(new Color(255, 250, 240));
        this.maText.setFont(new Font("Helvetica", 0, 9));
        this.maScrollPane = new JScrollPane(this.maText, 22, 32);
        this.maScrollPane.setPreferredSize(new Dimension(300, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.maScrollPane, gridBagConstraints);
    }

    @Override
    public void Update() {
    }

    private void UpdateVerticalScrollBar() {
        JScrollBar jScrollBar = this.maScrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            int n = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount() - 1;
            jScrollBar.setValue(n);
        }
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        this.maText.append(this.mnLineNo++ + ". " + NameProvider.getEventName(accessibleEventObject.EventId) + " : " + accessibleEventObject.OldValue.toString() + " -> " + accessibleEventObject.NewValue.toString() + "\n");
        this.UpdateVerticalScrollBar();
    }
}

