/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.lang.IndexOutOfBoundsException;
import javax.swing.JLabel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;

public class ParentView
extends ObjectView {
    private JLabel maParentLabel;
    private JLabel maIndexLabel;
    private JLabel maValidLabel;
    private JLabel maChildrenLabel;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            return new ParentView(objectViewContainer);
        }
        return null;
    }

    public ParentView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        ViewGridLayout viewGridLayout = new ViewGridLayout(this);
        this.maParentLabel = viewGridLayout.AddLabeledEntry("Has parent: ");
        this.maIndexLabel = viewGridLayout.AddLabeledEntry("Index in parent: ");
        this.maValidLabel = viewGridLayout.AddLabeledEntry("Parent/Child relationship valid: ");
        this.maChildrenLabel = viewGridLayout.AddLabeledEntry("Child count: ");
    }

    @Override
    public void Update() {
        if (this.mxContext == null) {
            this.maParentLabel.setText("<null object>");
            this.maIndexLabel.setText("<null object>");
            this.maValidLabel.setText("<null object>");
            this.maChildrenLabel.setText("<null object>");
        } else {
            block9: {
                XAccessible xAccessible = this.mxContext.getAccessibleParent();
                int n = this.mxContext.getAccessibleIndexInParent();
                this.maIndexLabel.setText(Integer.toString(n));
                if (xAccessible != null) {
                    this.maParentLabel.setText("yes");
                    XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                    if (xAccessibleContext != null) {
                        try {
                            XAccessible xAccessible2 = xAccessibleContext.getAccessibleChild(n);
                            if (xAccessible2 != this.mxContext) {
                                this.maValidLabel.setText("yes");
                                break block9;
                            }
                            this.maValidLabel.setText("no");
                            this.maValidLabel.setBackground(this.GetContainer().GetErrorColor());
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            this.maValidLabel.setText("no: invalid index in parent");
                            this.maValidLabel.setBackground(this.GetContainer().GetErrorColor());
                        }
                    } else {
                        this.maValidLabel.setText("no: parent has no context");
                        this.maValidLabel.setBackground(this.GetContainer().GetErrorColor());
                    }
                } else {
                    this.maParentLabel.setText("no");
                }
            }
            this.maChildrenLabel.setText(Integer.toString(this.mxContext.getAccessibleChildCount()));
        }
    }

    @Override
    public String GetTitle() {
        return "Parent";
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            default: 
        }
        this.Update();
    }
}

