/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.misc.NameProvider;

public class StateSetView
extends ObjectView {
    private static Color saInvalidColor = new Color(255, 0, 255);
    private static Color saFocusColor = new Color(100, 100, 255);
    private static Color saSelectionColor = Color.GREEN;
    private static Color saDefaultColor = new Color(90, 90, 90);
    private static Color saEditColor = new Color(240, 240, 0);

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        StateSetView stateSetView = null;
        if (xAccessibleContext != null) {
            stateSetView = new StateSetView(objectViewContainer);
        }
        return stateSetView;
    }

    public StateSetView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        this.setPreferredSize(new Dimension(300, 110));
        this.setMinimumSize(new Dimension(200, 80));
    }

    @Override
    public String GetTitle() {
        return "StateSet";
    }

    @Override
    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        if (accessibleEventObject.EventId == 4) {
            this.Update();
        }
    }

    @Override
    public void Update() {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintChildren(Graphics graphics) {
        if (graphics != null) {
            Graphics graphics2 = graphics;
            synchronized (graphics2) {
                super.paintChildren(graphics);
                Insets insets = this.getInsets();
                Dimension dimension = this.getSize();
                Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
                this.PaintAllStates((Graphics2D)graphics, rectangle);
            }
        }
    }

    private void PaintAllStates(Graphics2D graphics2D, Rectangle rectangle) {
        XAccessibleStateSet xAccessibleStateSet;
        Color color = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        XAccessibleStateSet xAccessibleStateSet2 = xAccessibleStateSet = this.mxContext != null ? this.mxContext.getAccessibleStateSet() : null;
        if (xAccessibleStateSet != null) {
            int n;
            short[] sArray = xAccessibleStateSet.getStates();
            int n2 = (rectangle.width - 12) / 31;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.setColor(color);
            int n3 = rectangle.y + rectangle.height - 25;
            double d = -0.9;
            double d2 = 0.6;
            int n4 = 8;
            Rectangle rectangle2 = new Rectangle(-n4 / 2, 0, n4, n4);
            for (short s = 0; s <= 30; s = (short)(s + 1)) {
                n = n2 + s * n2;
                String string = NameProvider.getStateName(s);
                if (string == null) {
                    string = new String("<unknown state " + s + ">");
                }
                boolean bl = xAccessibleStateSet.contains(s);
                graphics2D.setTransform(affineTransform);
                graphics2D.translate(n, n3);
                if (bl) {
                    switch (s) {
                        case 0: 
                        case 5: {
                            graphics2D.setColor(saInvalidColor);
                            break;
                        }
                        case 11: {
                            graphics2D.setColor(saFocusColor);
                            break;
                        }
                        case 23: {
                            graphics2D.setColor(saSelectionColor);
                            break;
                        }
                        case 6: {
                            graphics2D.setColor(saEditColor);
                            break;
                        }
                        default: {
                            graphics2D.setColor(saDefaultColor);
                        }
                    }
                    graphics2D.fill(rectangle2);
                    graphics2D.setColor(color);
                }
                graphics2D.draw(rectangle2);
                graphics2D.rotate(d);
                graphics2D.scale(d2, d2);
                graphics2D.translate(2, -2);
                graphics2D.drawString(string, 0, 0);
            }
            String string = new String();
            for (n = 0; n < sArray.length; ++n) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + NameProvider.getStateName(sArray[n]);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.translate(10, rectangle.y + rectangle.height - 3);
            graphics2D.scale(0.9, 0.9);
            graphics2D.drawString(string, 0, 0);
        }
    }
}

