/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

class ViewGridLayout {
    private static Font saFont = new Font("Dialog", 0, 11);
    private int mnCurrentLine;
    private JComponent maComponent;

    public ViewGridLayout(JComponent jComponent) {
        this.maComponent = jComponent;
        this.maComponent.setLayout(new GridBagLayout());
        this.maComponent.setMinimumSize(new Dimension(300, 30));
        this.maComponent.setMaximumSize(new Dimension(300, 1000));
        this.mnCurrentLine = 0;
    }

    public JLabel AddLabeledEntry(String string) {
        return (JLabel)this.AddLabeledComponent(string, new JLabel(""));
    }

    public JLabel AddLabeledString(String string) {
        JLabel jLabel = this.AddLabeledEntry(string);
        jLabel.setBackground(new Color(220, 220, 220));
        jLabel.setOpaque(true);
        return jLabel;
    }

    public JComponent AddLabeledComponent(String string, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = this.mnCurrentLine++;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(saFont);
        this.maComponent.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        jComponent.setFont(saFont);
        this.maComponent.add((Component)jComponent, gridBagConstraints);
        return jComponent;
    }

    public JComponent AddComponent(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = this.mnCurrentLine++;
        this.maComponent.add((Component)jComponent, gridBagConstraints);
        return jComponent;
    }

    public static Font GetFont() {
        return saFont;
    }
}

