/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.misc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MessageArea
extends JScrollPane {
    private static MessageArea saInstance = null;
    private JTextArea maText = new JTextArea();

    public static synchronized MessageArea Instance() {
        if (saInstance == null) {
            saInstance = new MessageArea();
        }
        return saInstance;
    }

    private MessageArea() {
        this.maText.setBackground(new Color(255, 250, 240));
        this.maText.setFont(new Font("Helvetica", 0, 9));
        this.setViewportView(this.maText);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
        this.printMessage("class path is " + System.getProperty("java.class.path") + "\n");
    }

    public static synchronized void print(String string) {
        MessageArea.print(0, string);
    }

    public static synchronized void print(int n, String string) {
        while (n-- > 0) {
            string = " " + string;
        }
        MessageArea.Instance().printMessage(string);
    }

    public static void println(String string) {
        MessageArea.println(0, string);
    }

    public static void println(int n, String string) {
        MessageArea.print(n, string + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics;
        synchronized (graphics2) {
            JScrollBar jScrollBar = this.getVerticalScrollBar();
            if (jScrollBar != null) {
                int n = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount() - 1;
                jScrollBar.setValue(n);
            }
            super.paintComponent(graphics);
        }
    }

    private synchronized void printMessage(String string) {
        this.maText.append(string);
    }
}

