/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.misc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawView;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XTask;
import com.sun.star.frame.XTasksSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import org.openoffice.accessibility.misc.MessageArea;
import org.openoffice.accessibility.misc.OfficeConnection;

public class SimpleOffice {
    private XDesktop mxDesktop;
    private static SimpleOffice saInstance = null;

    public static synchronized SimpleOffice Instance() {
        if (saInstance == null) {
            saInstance = new SimpleOffice();
        }
        return saInstance;
    }

    public static synchronized void Clear() {
        saInstance = null;
    }

    public XModel LoadDocument(String string) {
        XModel xModel = null;
        try {
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.mxDesktop);
            XComponent xComponent = xComponentLoader.loadComponentFromURL(string, "_blank", 0, new PropertyValue[0]);
            xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        }
        catch (NullPointerException nullPointerException) {
            MessageArea.println("caught exception while loading " + string + " : " + nullPointerException);
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while loading " + string + " : " + exception);
        }
        return xModel;
    }

    public XModel GetModel(String string) {
        XModel xModel = null;
        try {
            XTasksSupplier xTasksSupplier = (XTasksSupplier)UnoRuntime.queryInterface(XTasksSupplier.class, (Object)this.mxDesktop);
            XEnumerationAccess xEnumerationAccess = xTasksSupplier.getTasks();
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                XTask xTask = (XTask)UnoRuntime.queryInterface(XTask.class, (Object)xEnumeration.nextElement());
                MessageArea.print(xTask.getName());
            }
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while getting Model " + string + ": " + exception);
        }
        return xModel;
    }

    public XModel GetModel(XDrawView xDrawView) {
        XController xController = (XController)UnoRuntime.queryInterface(XController.class, (Object)xDrawView);
        if (xController != null) {
            return xController.getModel();
        }
        MessageArea.println("can't cast view to controller");
        return null;
    }

    public XDesktop GetDesktop() {
        if (this.mxDesktop != null) {
            return this.mxDesktop;
        }
        try {
            XMultiServiceFactory xMultiServiceFactory = OfficeConnection.Instance().GetServiceManager();
            if (xMultiServiceFactory == null) {
                MessageArea.println("can't connect to office");
                return null;
            }
            MessageArea.println("Connected successfully.");
            this.mxDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop"));
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while creating desktop: " + exception);
        }
        return this.mxDesktop;
    }

    public XExtendedToolkit GetExtendedToolkit() {
        XExtendedToolkit xExtendedToolkit = null;
        if (this != null) {
            try {
                XMultiServiceFactory xMultiServiceFactory = OfficeConnection.Instance().GetServiceManager();
                if (xMultiServiceFactory != null) {
                    xExtendedToolkit = (XExtendedToolkit)UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xMultiServiceFactory.createInstance("stardiv.Toolkit.VCLXToolkit"));
                }
            }
            catch (Exception exception) {
                MessageArea.println("caught exception while creating extended toolkit: " + exception);
            }
        }
        return xExtendedToolkit;
    }

    public static XAccessible GetAccessibleObject(XInterface xInterface) {
        XAccessible xAccessible = null;
        try {
            xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xInterface);
        }
        catch (Exception exception) {
            System.err.println("caught exception while getting accessible object" + exception);
            exception.printStackTrace(System.err);
        }
        return xAccessible;
    }

    public static XAccessibleContext GetAccessibleContext(XInterface xInterface) {
        XAccessible xAccessible = SimpleOffice.GetAccessibleObject(xInterface);
        if (xAccessible != null) {
            return xAccessible.getAccessibleContext();
        }
        return null;
    }

    public XAccessible GetAccessibleRoot(XAccessible xAccessible) {
        try {
            XAccessible xAccessible2 = null;
            do {
                XAccessibleContext xAccessibleContext;
                if ((xAccessibleContext = xAccessible.getAccessibleContext()) != null) {
                    xAccessible2 = xAccessibleContext.getAccessibleParent();
                }
                if (xAccessible2 == null) continue;
                xAccessible = xAccessible2;
            } while (xAccessible2 != null);
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while getting accessible root" + exception);
            exception.printStackTrace();
        }
        return xAccessible;
    }

    public XWindow GetCurrentWindow() {
        return this.GetCurrentWindow((XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.GetDesktop()));
    }

    public XWindow GetCurrentWindow(XModel xModel) {
        XWindow xWindow = null;
        try {
            XFrame xFrame;
            XController xController;
            if (xModel == null) {
                MessageArea.println("invalid model (==null)");
            }
            if ((xController = xModel.getCurrentController()) == null) {
                MessageArea.println("can't get controller from model");
            }
            if ((xFrame = xController.getFrame()) == null) {
                MessageArea.println("can't get frame from controller");
            }
            if ((xWindow = xFrame.getComponentWindow()) == null) {
                MessageArea.println("can't get window from frame");
            }
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while getting current window" + exception);
        }
        return xWindow;
    }

    public XDrawPage GetCurrentDrawPage() {
        return this.GetCurrentDrawPage((XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)this.GetCurrentView()));
    }

    public XDrawPage GetCurrentDrawPage(XDrawView xDrawView) {
        XDrawPage xDrawPage = null;
        try {
            if (xDrawView == null) {
                MessageArea.println("can't get current draw page from null view");
            } else {
                xDrawPage = xDrawView.getCurrentPage();
            }
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while getting current draw page : " + exception);
        }
        return xDrawPage;
    }

    public XDrawView GetCurrentView() {
        return this.GetCurrentView(this.GetDesktop());
    }

    public XDrawView GetCurrentView(XDesktop xDesktop) {
        if (xDesktop == null) {
            MessageArea.println("can't get desktop to retrieve current view");
        }
        XDrawView xDrawView = null;
        try {
            XController xController;
            XFrame xFrame;
            XComponent xComponent = xDesktop.getCurrentComponent();
            if (xComponent == null) {
                MessageArea.println("can't get component to retrieve current view");
            }
            if ((xFrame = xDesktop.getCurrentFrame()) == null) {
                MessageArea.println("can't get frame to retrieve current view");
            }
            if ((xController = xFrame.getController()) == null) {
                MessageArea.println("can't get controller to retrieve current view");
            }
            if ((xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController)) == null) {
                MessageArea.println("could not cast controller into view");
            }
        }
        catch (Exception exception) {
            MessageArea.println("caught exception while getting current view : " + exception);
        }
        return xDrawView;
    }

    public static XAccessible GetAccessibleDocumentWindow(XDrawPage xDrawPage) {
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xDrawPage);
        if (xIndexAccess.getCount() > 0) {
            XShape xShape = null;
            try {
                xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)xIndexAccess.getByIndex(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, xShape);
            return xAccessible;
        }
        return null;
    }

    private SimpleOffice() {
    }
}

