Vue.component("header-btns",{
template:`
	<div>
        <el-row>
           <button   class="Btn1" v-on:click="colorBtn('btn1')"></button>
           <button   class="Btn2" v-on:click="colorBtn('btn2')"></button>
           <button   class="Btn3" v-on:click="colorBtn('btn3')"></button>
           <button   class="Btn4" v-on:click="colorBtn('btn4')"></button>
           <button   class="Btn5" v-on:click="colorBtn('btn5')"></button>
          <template>
            <el-select style='width:100' v-model='colorNameTmp' placeholder='配色方案'  @change='selectColorName'>
              <el-option
                v-for='(item,index) in colorArr'
                :key='index'
                :label='item.name'
                :value='index'>
              </el-option>
            </el-select>
          </template>
           <el-divider direction='vertical'></el-divider>
          <el-color-picker v-model='textColor' @change='elColorPicChange'></el-color-picker>
          <el-color-picker v-model='bgColor' @change='elColorPicChange'></el-color-picker>
          <el-button size='mini' round  v-on:click="colorBtn('rand')">随机配色</el-button>
          <el-divider direction='vertical'></el-divider>
          <el-button icon='el-icon-full-screen' circle v-on:click="colorBtn('full')"></el-button>
          <el-button icon='el-icon-star-off' circle v-on:click="colorBtn('fav')"></el-button>
          <el-select v-model="fontNameTmp" placeholder="请选择字体"  @change="selectOne">
              <el-option
              v-for="item in optionsArr"
              :key="item.value"
              :label="item.value"
              :value="item.value">
            </el-option>
          </el-select>
         </el-row>
       <el-divider></el-divider>
	</div>
	
	`,
	props:["colorArr","optionsArr","fontSizeOptionsArr","colorName","textColor","bgColor","fontName","fontSize"],
  data(){
    return{
      fontSizeTmp:this.fontSize,
      colorNameTmp:this.colorName,
      fontNameTmp:this.fontName
    }
  },
	methods:{

    colorBtn(key)
    {
      this.$emit("color-btn",key)
    },

    selectColorName(key)
    {
      console.log(key)
      this.$emit("select-color-name",key)
    },
    elColorPicChange(){
      this.$emit("el_color-pic_change")
    }
    ,
    selectOne(fontName)
    {
       this.$emit("select-one",fontName)
    }
    // ,
    // selectFontSize(fontSize)    @change='selectFontSize'
    // {
    //     this.$emit("select-font-size",fontSize)
    // }

	},
    watch: {
      fontSizeTmp(newVar,oldVar){
        console.log(newVar)
    //    this.fontSize=newVar;
        this.$emit("select-font-size",newVar)
      }

    },

})