local assets =
{
	Asset("ANIM", "anim/bandage.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("bandage")
    inst.AnimState:SetBuild("bandage")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
local function OnDeploy (inst, pt)
    local helper = SpawnPrefab("bandage")
    helper.Transform:SetPosition(pt.x, pt.y, pt.z)
    helper.AnimState:SetBank("kiki")
    helper.AnimState:SetBuild("kiki_basic")
    helper.AnimState:PlayAnimation("idle_loop", true)
    helper.Transform:SetFourFaced()
    helper.Transform:SetScale(0.8, 0.8, 0.8)
    helper:RemoveComponent("stackable")
    helper:RemoveComponent("healer")
    local sound = helper.entity:AddSoundEmitter()	
    helper.soundtype = ""
    local brain = require "brains/abigailbrain"
    helper:SetBrain(brain)
    helper:AddComponent("locomotor")
    helper.components.locomotor:SetTriggersCreep(false)
    helper.components.locomotor.pathcaps = { ignorecreep = false }
    helper.components.locomotor.walkspeed = 5
    helper:SetStateGraph("SGmonkey")
    helper:AddComponent("follower")
    GetPlayer().components.leader:AddFollower(helper)
    helper:AddComponent("combat")
    helper.components.combat.hiteffectsymbol = "torso"
    helper.components.combat:SetRetargetFunction(1, function(helper)
        if not helper.components.health:IsDead() then
            return FindEntity(helper, 20, function(guy)
                if guy.components.health and not guy.components.health:IsDead() then
                   return guy:HasTag("bird") or guy:HasTag("bee") or guy:HasTag("rabbit")
                end
            end)
        end
    end )
    helper.components.combat:SetKeepTargetFunction(function(helper, target) return target and target:IsValid() end )
    helper.components.combat:SetAttackPeriod(1)
    helper.components.combat:SetRange(1, 2)
    helper.components.combat:SetDefaultDamage(1)
    helper.components.combat.onhitotherfn = function(helper, other, damage)
        if other.components.inventoryitem then
           GetPlayer().components.inventory:GiveItem(other)
        end
    end
    helper:AddComponent("health")
    helper.components.health:SetMaxHealth(1000)
    helper.components.health:SetInvincible(true)
    helper.components.health.nofadeout = true
    helper.components.inventoryitem:ChangeImageName("cave_banana")
    helper:AddTag("helpers")
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

local function onsave(inst, data)
    if inst:HasTag("helpers") then
        data.helpers = true
    end
end
local function onload(inst, data)
  if data and data.helpers then
    inst.AnimState:SetBank("kiki")
    inst.AnimState:SetBuild("kiki_basic")
    inst.AnimState:PlayAnimation("idle_loop", true)
    inst.Transform:SetFourFaced()
    inst.Transform:SetScale(0.8, 0.8, 0.8)
    inst:RemoveComponent("stackable")
    inst:RemoveComponent("healer")
    local sound = inst.entity:AddSoundEmitter()	
    inst.soundtype = ""
    local brain = require "brains/abigailbrain"
    inst:SetBrain(brain)
    inst:AddComponent("locomotor")
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = false }
    inst.components.locomotor.walkspeed = 5
    inst:SetStateGraph("SGmonkey")
    inst:AddComponent("follower")
    GetPlayer().components.leader:AddFollower(inst)
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetRetargetFunction(1, function(inst)
        if not inst.components.health:IsDead() then
            return FindEntity(inst, 20, function(guy)
                if guy.components.health and not guy.components.health:IsDead() then
                   return guy:HasTag("bird") or guy:HasTag("bee") or guy:HasTag("rabbit")
                end
            end)
        end
    end )
    inst.components.combat:SetKeepTargetFunction(function(inst, target) return target and target:IsValid() end )
    inst.components.combat:SetAttackPeriod(1)
    inst.components.combat:SetRange(1, 2)
    inst.components.combat:SetDefaultDamage(1)
    inst.components.combat.onhitotherfn = function(inst, other, damage)
        if other.components.inventoryitem then
           GetPlayer().components.inventory:GiveItem(other)
        end
    end
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1000)
    inst.components.health:SetInvincible(true)
    inst.components.health.nofadeout = true
    inst.components.inventoryitem:ChangeImageName("cave_banana")
    inst:AddTag("helpers")
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload    
    inst:AddComponent("healer")
    inst.components.healer:SetHealthAmount(TUNING.HEALING_MEDLARGE)
    
    return inst
end

return Prefab( "common/inventory/bandage", fn, assets) 

