CREATE TABLE [dbo].[SYS_AGAINID](
	[AID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[AGAINID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[AGAINDATE] [datetime] NULL,
	[ISLOCK] [bit] NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_AUTOID](
	[AID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[NAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[IDSET] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[IDDATE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[IDLEN] [int] NULL,
	[IDMAX] [int] NULL,
	[ISSAVE] [bit] NULL,
	[ISAGAIN] [bit] NULL,
	[ENDDATE] [datetime] NULL,
	[SEQ] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_Sys_AutoID] PRIMARY KEY CLUSTERED 
(
	[AID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_BACKUP](
	[ID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[DATABASENAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[BACKUPPATH] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[FILESNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[SEQ] [int] IDENTITY(1,1) NOT NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_BASIS](
	[ID] [int] NOT NULL,
	[TITLE] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[IMAGEDATA] [image] NULL,
 CONSTRAINT [PK_Sys_Basis] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_BULLETIN](
	[ID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CDID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CDATE] [datetime] NULL,
	[EDATE] [datetime] NULL,
	[TITLE] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[CONTENT] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[VIEWUSER] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_DATATYPE](
	[ID] [int] NOT NULL,
	[DATATYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[KEYWORD] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_DEPT](
	[DID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[PID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[DEPTNUMBER] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[DEPTNAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[DEPTREMARK] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_Dept] PRIMARY KEY CLUSTERED 
(
	[DID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FIELD](
	[FID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[TID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDNAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDALIAS] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDSHEET] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDADDRESS] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDLENGTH] [int] NULL,
	[FIELDDECIMAL] [int] NULL,
	[DATATYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISKEY] [bit] NULL,
	[ISREQUIRED] [bit] NULL,
	[ISEDIT] [bit] NULL,
	[ISHIDE] [bit] NULL,
	[REQUIREDMSG] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[SEQ] [int] NULL,
	[HYPERLINK] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ISVIEWDATE] [bit] NULL,
	[ISVIEWTIME] [bit] NULL,
	[FIELDFORMULA] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ISDATE] [bit] NULL,
	[ISTIME] [bit] NULL,
	[ISNOTDATA] [bit] NULL,
	[ISTHE] [bit] NULL,
	[IMAGEW] [int] NULL,
	[IMAGEH] [int] NULL,
	[ISFC] [bit] NULL,
 CONSTRAINT [PK_Sys_Field] PRIMARY KEY CLUSTERED 
(
	[FID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FIELD_EV](
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FIELDNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FLOWDETAIL](
	[ID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[WFID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[NT] [int] NULL,
	[UUID] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[TUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[PUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RRID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[NID] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[NN] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[PID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[SDATE] [datetime] NULL,
	[TDATE] [datetime] NULL,
	[DP] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[LUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISLOCK] [bit] NULL,
	[ISUNDO] [bit] NULL,
	[ISBACK] [bit] NULL,
	[ISREDO] [bit] NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FLOWREAD](
	[UID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FDID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FORMULA](
	[FID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[SEQ] [int] NULL,
	[FORMULANAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[ISENABLE] [bit] NULL,
	[FORMULATYPE] [int] NULL,
	[FORMULACONTENT] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[FORMULAWHERE] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[FILLTABLE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[EXECADD] [bit] NULL,
	[EXECEDIT] [bit] NULL,
	[EXECVIEW] [bit] NULL,
	[EXECCHANGE] [bit] NULL,
	[EXECMANAGE] [bit] NULL,
	[EXECSAVE] [bit] NULL,
	[EXECDEL] [bit] NULL,
	[DELETEROW] [bit] NULL,
	[BUTTON] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ISCLEARALL] [bit] NULL,
	[ISCLEARFILL] [bit] NULL,
	[ISSHARE] [bit] NULL,
	[EXECSAVETYPE] [int] NULL,
	[ISDISTINCT] [bit] NULL,
	[WHERESITE] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ISFILLDETAIL] [bit] NULL,
	[ISSQL] [bit] NULL,
	[FORMULAREMARK] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ISFLOW] [bit] NULL,
	[FLOWNODES] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[COLUMNSORT] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[ISPROCEDURE] [bit] NULL,
	[ISTOP] [int] NULL,
	[ISGROUP] [bit] NULL,
	[ISCOLSUM] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISROWSUM] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_Formula] PRIMARY KEY CLUSTERED 
(
	[FID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FORMULA_FILL](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[SOURCEALIAS] [varchar](500) COLLATE Chinese_PRC_CI_AS NULL,
	[FILLTYPE] [int] NULL,
	[FILLFIELD] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FILLALIAS] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ISLOCK] [bit] NULL,
	[ORDERBY] [int] NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FORMULA_LIST](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[RID] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[FID] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[SOURCE] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[SOURCEALIAS] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ORDERBY] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[FILLFIELD] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CHAGEFIELD] [bit] NOT NULL,
	[HIDEFIELD] [bit] NOT NULL,
	[DEFAULTRETURN] [bit] NOT NULL,
 CONSTRAINT [PK_Sys_Formula_List] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_FORMULA_TABLE](
	[FTID] [int] IDENTITY(1,1) NOT NULL,
	[FID] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLEALIAS] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLENAME] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_Formula_Table] PRIMARY KEY CLUSTERED 
(
	[FTID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_GROUP](
	[GID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[PID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[GROUPNUMBER] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[GROUPNAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[REMARK] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ISEXPANDED] [bit] NOT NULL,
	[ICO] [image] NULL,
 CONSTRAINT [PK_Sys_Group] PRIMARY KEY CLUSTERED 
(
	[GID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_HOME_GRID](
	[TYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[NUMBER] [int] NOT NULL,
	[WHLEN] [int] NULL,
 CONSTRAINT [PK_SYS_HOME_GRID] PRIMARY KEY CLUSTERED 
(
	[TYPE] ASC,
	[NUMBER] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_IMAGE](
	[PID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[IMAGEDATA] [image] NULL,
 CONSTRAINT [PK_SYS_IMAGE_1] PRIMARY KEY CLUSTERED 
(
	[PID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_LOG](
	[LID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[COMPUTERNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[USERNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[LOGTYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[LOGDATE] [datetime] NULL,
	[LOGDETAIL] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_Log] PRIMARY KEY CLUSTERED 
(
	[LID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_ONLINE](
	[ID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[UUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[USERNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[LOGINDATE] [datetime] NULL,
	[COMPUTERNAME] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[LASTTIME] [datetime] NULL,
 CONSTRAINT [PK_Sys_Online] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_PLUGIN](
	[ID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[PLUGINTYPE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISENABLE] [bit] NULL,
	[ROWS] [int] NULL,
	[ROWC] [int] NULL,
	[COLS] [int] NULL,
	[COLC] [int] NULL,
	[SEQ] [int] NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[IID] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[WH] [int] NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_PURVIEW](
	[PID] [int] IDENTITY(1,1) NOT NULL,
	[UUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[REPORTADD] [bit] NULL,
	[REPORTVIEW] [int] NULL,
	[REPORTEDIT] [int] NULL,
	[REPORTDEL] [int] NULL,
	[REPORTOUT] [bit] NULL,
	[REPORTPRINT] [bit] NULL,
	[BATCHEXPORT] [bit] NULL,
	[BULKIMPORT] [bit] NULL,
	[CUSTOMVIEW] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_SYSTEM](
	[SID] [int] NOT NULL,
	[MAXID] [int] NULL,
	[SITE] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_System] PRIMARY KEY CLUSTERED 
(
	[SID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_TABLE](
	[TID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLENAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLEALIAS] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLESHEET] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[AREAADDRESS] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[TABLETYPE] [int] NULL,
	[SEQ] [int] NULL,
	[MERGEAREA] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMWHERE] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[FROZENCOLUMN] [int] NULL,
	[ISNOTSAVE] [bit] NULL,
	[ISHIDE] [bit] NULL,
 CONSTRAINT [PK_Sys_Table] PRIMARY KEY CLUSTERED 
(
	[TID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_TEMPLATE](
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[TEMPLATENUMBER] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TEMPLATENAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[GID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISENABLE] [bit] NULL,
	[FILES] [image] NULL,
	[ISQUERY] [bit] NULL,
	[ISGRIDLINE] [bit] NULL,
	[ISHEADING] [bit] NULL,
	[ISSHEET] [bit] NULL,
	[ISHSCROLLBAR] [bit] NULL,
	[ISVSCROLLBAR] [bit] NULL,
	[ISZERO] [bit] NULL,
	[ISPROTECT] [bit] NULL,
	[ISSUPER] [bit] NULL,
	[ISHIDESAVE] [bit] NULL,
	[ISHIDEPRINT] [bit] NULL,
	[ISHIDEOUT] [bit] NULL,
	[ISHIDEPIC] [bit] NULL,
	[ISHIDEIR] [bit] NULL,
	[ISHIDEIRS] [bit] NULL,
	[ISHIDEDR] [bit] NULL,
	[ISHIDESUBMIT] [bit] NULL,
	[ISHIDEBACK] [bit] NULL,
	[ISHIDETOOL] [bit] NULL,
	[ISFC] [bit] NULL,
	[WINDOWW] [int] NULL,
	[WINDOWH] [int] NULL,
	[ISHIDEFIND] [bit] NULL,
	[ISHIDEUPLOAD] [bit] NULL,
	[ISMAXWINDOW] [bit] NULL,
	[ISFLOW] [bit] NULL,
	[FLOWREMARK] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[WORKFLOW] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[ICO] [image] NULL,
	[ADDNAME] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[SELCOLOR] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISERRMSG] [bit] NULL,
	[BACKIMG] [image] NULL,
	[BACKOPA] [decimal](18, 2) NULL,
	[BACKFILL] [int] NULL,
	[ISPOP] [bit] NULL,
	[UUID] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[DLLFILE] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CLASSNAME] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[FRL] [bit] NULL,
	[ISHIDECAMERA] [bit] NULL,
	[ISCLOSEMSG] [bit] NULL,
	[CLOSETIPS] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[ISHIDEADDUSER] [bit] NULL,
	[ISHIDEADDDATE] [bit] NULL,
	[ISHIDEALTERUSER] [bit] NULL,
	[ISHIDEALTERDATE] [bit] NULL,
	[TITLECOLOR] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[DOUBLECLICK] [bit] NULL,
 CONSTRAINT [PK_Sys_Template] PRIMARY KEY CLUSTERED 
(
	[RID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_TEMPLATE_CHART](
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TEMPLATENUMBER] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TEMPLATENAME] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[GID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ICO] [image] NULL,
	[TITLECOLOR] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISSUPER] [bit] NULL,
	[ISENABLE] [bit] NULL,
	[ISSINGLE] [bit] NULL,
	[ISGRID] [bit] NULL,
	[ISPOS] [bit] NULL,
	[ISANGLE] [bit] NULL,
	[ISVALUE] [bit] NULL,
	[ISCDS] [bit] NULL,
	[TYPEID] [int] NULL,
	[PALETTEID] [int] NULL,
	[EXECSQL] [text] COLLATE Chinese_PRC_CI_AS NULL,
	[CIN] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CDV] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CDS] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UUID] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_TEMPLATE_OLAP](
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[TEMPLATENUMBER] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[TEMPLATENAME] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[GID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISENABLE] [bit] NULL,
	[SQLCONTENT] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[ISPROTECT] [bit] NULL,
	[ISSUPER] [bit] NULL,
	[ICO] [image] NULL,
        [TITLECOLOR] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UUID] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL,
	[ISHIDESET] [bit] NULL,
	[ISHIDESTAT] [bit] NULL,
	[ISHIDECHART] [bit] NULL,
	[ISHIDEDETAILS] [bit] NULL,
	[ISHIDECHARTTITLE] [bit] NULL,
	[ISHIDECHARTLINE] [bit] NULL,
	[ISHIDERIGHT] [bit] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

CREATE TABLE [dbo].[SYS_USER](
	[UUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
	[USERNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[LOGINNAME] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[USERPASS] [varchar](250) COLLATE Chinese_PRC_CI_AS NULL,
	[USERMOBILE] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[USEREMAIL] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[DID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[ISENABLE] [bit] NULL,
	[ISMANAGE] [bit] NULL,
	[ISDESIGN] [bit] NULL,
	[ISGROUP] [bit] NULL,
	[ISBULLETIN] [bit] NULL,
	[ISANIMATION] [bit] NULL,
	[USERREMARK] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL,
	[SEQ] [int] IDENTITY(1,1) NOT NULL,
	[CUSTOMTEXT1] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMTEXT2] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMTEXT3] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMTEXT4] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMTEXT5] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
	[CUSTOMINT1] [int] NULL,
	[CUSTOMINT2] [int] NULL,
	[CUSTOMDATE1] [datetime] NULL,
	[CUSTOMDATE2] [datetime] NULL,
	[TREEWIDTH] [int] NULL,
	[SKIN] [varchar](255) COLLATE Chinese_PRC_CI_AS NULL,
 CONSTRAINT [PK_Sys_User] PRIMARY KEY CLUSTERED 
(
	[UUID] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_USER_OLAP](
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[UUID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[CID] [int] NULL,
	[TYPE] [int] NULL,
	[XML] [varchar](4000) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[SYS_WORKFLOW](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[WFID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[RID] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[MD5] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
	[FW] [varchar](max) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]

CREATE TABLE [dbo].[T_0](
	[F_0] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL
) ON [PRIMARY]


