ALTER PROCEDURE [dbo].[KBAutoID]
@Name NVarchar(50),--自动编号中文名称
@Type Varchar(3),--生成编号：GRE 删除废号：DEL 记录废号：INS 解锁废号：ULK
@Rid Varchar(50),--调用的模板ID
@Field Varchar(50),--调用的字段名称
@Number Varchar(50), --对应参数2的唯一ID
@Param Varchar(50) --额外参数
AS
BEGIN
 --20200417 V2.1.9
 Declare @return NVarchar(50),@FRV Varchar(50),@AGAINID Varchar(50),@OldMAXID Varchar(50),@DateChange Bit,@TN Varchar(50),@FN Varchar(50)
 Declare @AID Varchar(50),@IDSET NVarchar(50),@IDLEN int,@IDMAX int,@IDDATE Varchar(50),@ISAGAIN Bit,@ENDDATE Datetime,@FORMATID Varchar(50),@MAXIDS Varchar(max)
 If @Type = 'GRE'
	Begin
		 --取出自动编号设置
		 SET NOCOUNT ON;
		 Begin Tran --开启事务，用于行锁定
		 Declare CTmp cursor for SELECT AID,IDSET,IDDATE,IDLEN,IDMAX,ISAGAIN,ENDDATE,FORMATID,MAXIDS FROM SYS_AUTOID WITH (ROWLOCK,UPDLOCK) WHERE NAME = @Name
		 Open CTmp
			 Fetch CTmp Into @AID,@IDSET,@IDDATE,@IDLEN,@IDMAX,@ISAGAIN,@ENDDATE,@FORMATID,@MAXIDS
    			 Begin
					Set @DateChange = '0';
					--首先处理是否存在废号
					If @ISAGAIN = 1
					   Begin 
							--查找废号
							Declare CAgain cursor for SELECT TOP 1 AGAINID FROM SYS_AGAINID WITH (ROWLOCK,UPDLOCK) WHERE AID = @AID AND ISLOCK = '0' 
							AND ((@IDDATE = 'yyyyMMdd' AND CONVERT(VARCHAR(10),GETDATE(),112) = CONVERT(VARCHAR(10),AGAINDATE,112))
							OR (@IDDATE = 'yyyyMM' AND CONVERT(VARCHAR(6),GETDATE(),112) = CONVERT(VARCHAR(6),AGAINDATE,112))
							OR (@IDDATE = 'yyMMdd' AND CONVERT(VARCHAR(6),GETDATE(),12) = CONVERT(VARCHAR(6),AGAINDATE,12))
							OR (@IDDATE = 'yyMM' AND CONVERT(VARCHAR(4),GETDATE(),12) = CONVERT(VARCHAR(4),AGAINDATE,12))
							OR (@IDDATE = 'yy' AND CONVERT(VARCHAR(2),GETDATE(),12) = CONVERT(VARCHAR(2),AGAINDATE,12))
							OR (@IDDATE = 'yyyyMd' AND YEAR(GETDATE()) = YEAR(AGAINDATE) AND MONTH(GETDATE()) = MONTH(AGAINDATE) AND DAY(GETDATE()) = DAY(AGAINDATE))
							OR (@IDDATE = 'yyyy' AND CONVERT(VARCHAR(4),GETDATE(),112) = CONVERT(VARCHAR(4),AGAINDATE,112))
							OR @IDDATE = '无') AND (@FORMATID='' OR (CharIndex('[PARAM]',@FORMATID) > 0 AND [PARAM] = @Param))  ORDER BY AGAINDATE
							Open CAgain
								Fetch CAgain Into @AGAINID
							Close CAgain 
							Deallocate CAgain
					   End
					If @AGAINID Is Null
					   --没有废号，生成新号
					   Begin
						  --截取对应的格式位数
						  Set @FRV = Power(CAST(10 AS DECIMAL(10,0)),@IDLEN)
						  If @FORMATID = '' And @IDDATE <> '无'
							Begin
								Set @FORMATID = '[TEXT][DATE][NUM]'
							End
						  Else if   @FORMATID = '' And @IDDATE = '无'
							Begin
								Set @FORMATID = '[TEXT][NUM]'
							End
						  If @IDDATE = '无'
							 Begin
								--判断变量是否存在
								If CharIndex('[PARAM]',@FORMATID) > 0
									Begin
										If CharIndex('['+@Param+'=',@MAXIDS) > 0
											--有变量规则的最大号
											Begin
												Declare @StartI int 
												Set @StartI = CharIndex('['+@Param+'=',@MAXIDS) + Len('['+@Param+'=');
												Declare @StartL int 
												Set @StartL = CharIndex(']', @MAXIDS,@StartI);
												Set @IDMAX = SubString(@MAXIDS,@StartI,@StartL - @StartI);
												Set @OldMAXID = @IDMAX;
											End	
										Else 
										    --没有变量规则的最大号从1开始
										    Begin
												Set @OldMAXID = @IDMAX;
											    Set @IDMAX = 1
										    End
									End
								--不含日期部分
								Set @return = Replace(@FORMATID,'[TEXT]',@IDSET)
								Set @return = Replace(@return,'[PARAM]',@Param)
								Set @return = Replace(@return,'[NUM]',right(Cast(@IDMAX + CAST(@FRV AS DECIMAL(21,0)) As Varchar),@IDLEN))
							 End
						  Else
							 Begin
								 --判断是否一个日期格式@ENDDATE
								 If (((@IDDATE = 'yy' Or @IDDATE = 'yyyy') And Year(GetDate()) <> Year(@ENDDATE))
								 OR ((@IDDATE = 'yyyyMM' Or @IDDATE = 'yyMM') And (Year(GetDate()) <> Year(@ENDDATE) Or Month(GetDate()) <> Month(@ENDDATE))) 
								 OR ((@IDDATE = 'yyyyMMdd' Or @IDDATE = 'yyMMdd' Or @IDDATE = 'yyyyMd') And (Year(GetDate()) <> Year(@ENDDATE) Or Month(GetDate()) <> Month(@ENDDATE) Or Day(GetDate()) <> Day(@ENDDATE))))
									Begin
									   Set @DateChange = '1';
									   Set @OldMAXID = @IDMAX;
									   Set @IDMAX = 1
									End
								 Else If CharIndex('[PARAM]',@FORMATID) > 0 AND CharIndex('['+@Param+'=',@MAXIDS) > 0
								    Begin
										Declare @StartK int 
										Set @StartK = CharIndex('['+@Param+'=',@MAXIDS) + Len('['+@Param+'=');
										Declare @StartJ int 
										Set @StartJ = CharIndex(']', @MAXIDS,@StartK)
										Set @IDMAX = SubString(@MAXIDS,@StartK,@StartJ - @StartK);
										Set @OldMAXID = @IDMAX;
									End
								Else If CharIndex('[PARAM]',@FORMATID) > 0 AND CharIndex('['+@Param+'=',@MAXIDS) = 0
									Begin
										Set @OldMAXID = @IDMAX;
										Set @IDMAX = 1
									End
								 --含日期格式的编号
								 Set @return = Replace(@FORMATID,'[TEXT]',@IDSET)
								 Set @return = Replace(@return,'[DATE]',Case When @IDDATE = 'yyyyMMdd' Then Convert(Varchar(10),GetDate(),112) 
								 When @IDDATE = 'yyyyMM' Then Convert(Varchar(6),GetDate(),112)
								 When @IDDATE = 'yyMMdd' Then Convert(Varchar(6),GetDate(),12)
								 When @IDDATE = 'yyMM' Then Convert(Varchar(4),GetDate(),12)
								 When @IDDATE = 'yy' Then Convert(Varchar(2),GetDate(),12)
								 When @IDDATE = 'yyyyMd' Then Convert(Varchar(4),GetDate(),112)+ Cast(Month(Getdate()) As Varchar)+ Cast(Day(Getdate()) As Varchar)
								 When @IDDATE = 'yyyy' Then Convert(Varchar(4),GetDate(),112)
								 End)
								 Set @return = Replace(@return,'[PARAM]',@Param)
								 Set @return = Replace(@return,'[NUM]',right(Cast(@IDMAX + @FRV As Varchar),@IDLEN))
							  End
						  --如果生成了编号，最大号加1
						  If @return Is Not Null
							 Begin
								--判断是否包含变量部分
								If CharIndex('[PARAM]',@FORMATID) > 0
									Begin
										Set @IDMAX = @IDMAX + 1;
										If CharIndex('['+@Param+'=',@MAXIDS) > 0 And @DateChange = '0'
											Begin
												Exec('UPDATE SYS_AUTOID SET IDMAX=' + @IDMAX + ',ENDDATE=GETDATE(),MAXIDS=REPLACE(MAXIDS,''[' + @Param + '=' + @OldMAXID + ']'',''[' + @Param + '=' + @IDMAX + ']'') WHERE AID=''' + @AID + '''')
											End
										Else If CharIndex('['+@Param+'=',@MAXIDS) = 0 And @DateChange = '0'
											Begin
												Exec('UPDATE SYS_AUTOID SET IDMAX=' + @IDMAX + ',ENDDATE=GETDATE(),MAXIDS=MAXIDS+''[' + @Param + '=' + @IDMAX + ']'' WHERE AID=''' + @AID + '''')
											End
										Else If @DateChange = '1'
											Begin
												Exec('UPDATE SYS_AUTOID SET IDMAX=' + @IDMAX + ',ENDDATE=GETDATE(),MAXIDS=''[' + @Param + '=' + @IDMAX + ']'' WHERE AID=''' + @AID + '''')
											End
									End
								Else
									--不包含变量部分，直接更新最大号
								    Begin
										Exec('UPDATE SYS_AUTOID SET IDMAX=' + @IDMAX + '+ 1,ENDDATE=GETDATE() WHERE AID=''' + @AID + '''')
									End
								if @ISAGAIN = 1
									Begin
										--记录废号并锁定
										If CharIndex('[PARAM]',@FORMATID) > 0
											Begin
												Exec('INSERT INTO SYS_AGAINID(AID,AGAINID,AGAINDATE,ISLOCK,PARAM) VALUES(''' + @AID + ''',''' + @return + ''',GETDATE(),''1'',''' + @Param + ''')')
												--记录使用编号的信息，便于删除时变为废号(1、表间公式自动编号改字段后，需要删除原记录内容，避免后续还在生成废号；)
												SELECT @TN = TABLENAME FROM SYS_VIEW_TABLEFIELD WHERE RID = ''+ @RID + '' AND FIELDNAME = ''+ @Field + ''
												if @TN IS NOT NULL
													Begin
														Exec('INSERT INTO SYS_AGAINID_RENEW SELECT '''+ @Rid +''','''+ @AID +''','''+ @TN +''','''+ @Field +''','''+ @Param +''' WHERE NOT EXISTS(SELECT RID FROM SYS_AGAINID_RENEW WHERE RID='''+@Rid+''' AND AID ='''+@AID+''' AND TABLENAME = '''+@TN+''' AND FIELDNAME = '''+@Field+''' AND PARAM = '''+@Param+''')')
													End
											End
										Else
											Begin
												Exec('INSERT INTO SYS_AGAINID(AID,AGAINID,AGAINDATE,ISLOCK,PARAM) VALUES(''' + @AID + ''',''' + @return + ''',GETDATE(),''1'','''')')
												SELECT @TN = TABLENAME FROM SYS_VIEW_TABLEFIELD WHERE RID = ''+ @RID + '' AND FIELDNAME = ''+ @Field + ''
												if @TN IS NOT NULL
													Begin
														Exec('INSERT INTO SYS_AGAINID_RENEW SELECT '''+ @Rid +''','''+ @AID +''','''+ @TN +''','''+ @Field +''','''' WHERE NOT EXISTS(SELECT RID FROM SYS_AGAINID_RENEW WHERE RID='''+@Rid+''' AND AID ='''+@AID+''' AND TABLENAME = '''+@TN+''' AND FIELDNAME = '''+@Field+''')')
													End
											End										
									End
							 End
					   End
					Else
					   --存在废号，使用废号并锁定
					   Begin
						   Set @return = @AGAINID
						   Exec('UPDATE SYS_AGAINID SET ISLOCK=''1'' WHERE AID=''' + @AID + ''' AND AGAINID =''' + @AGAINID + '''')
					   End
				 End
		  --没有找到内容返回空值
		  If @return Is Null
			Begin
				Set @return = ''
			End
		  Else If @ISAGAIN = 1
			Begin
				--如果废号可重用，记录到临时表供下一步处理
				Exec('INSERT INTO SYS_AGAINID_WAIT(AID,UQID,AGAINID) VALUES('''+@AID+''','''+@Number+''','''+@return+''')');
			End
		 --关闭游标并销毁
		  Close CTmp 
		  Deallocate CTmp
		  Commit Tran
		 --返回自动编号 
		  Select @AID As AID,@return As Num,@ISAGAIN As Again
	   End
  Else If  @Type = 'DEL'
	       Begin
				SET NOCOUNT ON;
				Begin Tran
				Exec('DELETE FROM SYS_AGAINID WHERE AGAINID IN (SELECT AGAINID FROM SYS_AGAINID_WAIT WHERE UQID = '''+ @Number + ''')');
				Exec('DELETE FROM SYS_AGAINID_WAIT WHERE UQID = '''+ @Number + '''');
				Commit Tran
		   End
  Else If  @Type = 'INS'
	       Begin
				Begin Tran
				Declare CTmp1 cursor for SELECT AID,TABLENAME,FIELDNAME,PARAM FROM SYS_AGAINID_RENEW WHERE RID = @RID
				Open CTmp1
					Fetch CTmp1 Into @AID,@TN,@FN,@Param
					While @@fetch_status>=0
						Begin
							--获取主表的名称
							Declare @TNM varchar(50),@DateBf varchar(250)
							SELECT @TNM = TABLENAME FROM SYS_TABLE WHERE RID = ''+ @RID + '' AND TABLETYPE = 1
							if @TN = @TNM
								Begin
									--如果是主表，使用填报日期作为废号的创建时间
									Set @DateBf = 'CDATE'
								End
							Else
								Begin
									--如果是明细表，使用主表的集合获得CDATE填报日期作为废号的创建时间
									Set @DateBf = '(SELECT CDATE FROM '+ @TNM +' WHERE ID = '''+ @Number +''')'
								End
							--开始还原
							Exec('INSERT INTO SYS_AGAINID SELECT '''+ @AID +''','+ @FN +','+ @DateBf +',''0'','''+ @Param +''' FROM '+ @TN +' WHERE ID='''+ @Number +''' 
							AND ('+ @FN +'<>'''' AND '+ @FN +' IS NOT NULL) AND NOT EXISTS(SELECT AGAINID FROM SYS_AGAINID WHERE AID='''+ @AID +''' AND AGAINID = '+ @FN +')');
							--游标下一条记录
							FETCH NEXT FROM CTmp1 Into @AID,@TN,@FN,@Param
						End
				--关闭并销毁游标
				Close CTmp1
				Deallocate CTmp1
				Commit Tran
		   End
  Else If  @Type = 'ULK'
	       Begin
				SET NOCOUNT ON;
				Begin Tran
				--解锁废号及等待的唯一标识
				Exec('UPDATE SYS_AGAINID SET ISLOCK =''0'' WHERE AGAINID IN (SELECT AGAINID FROM SYS_AGAINID_WAIT WHERE UQID = '''+ @Number + ''')');
				Exec('DELETE FROM SYS_AGAINID_WAIT WHERE UQID = '''+ @Number + '''');
				--解锁300分钟以上的废号及等待的唯一标识
				Exec('DELETE FROM SYS_AGAINID_WAIT WHERE AID+AGAINID IN (SELECT AID+AGAINID FROM SYS_AGAINID WHERE ISLOCK =''1'' AND datediff(minute,AGAINDATE,getdate()) > 300)');
				Exec('UPDATE SYS_AGAINID SET ISLOCK =''0'' WHERE datediff(minute,AGAINDATE,getdate()) > 300');
				Commit Tran
		   End
 -- Return 
End