
local MakePlayerCharacter = require "prefabs/player_common"
local easing = require "easing"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/kurumi.zip" ),
        Asset( "ANIM", "anim/ghost_kurumi_build.zip" ),
		Asset( "ANIM", "anim/kurumi_timepiont.zip" ),
		
		Asset("ATLAS", "images/kurumitab.xml"),
		
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"kurumi_gun",
}

--[[
local function applyupgrades(inst)
    local max_upgrades = 6
    inst.level = math.min(inst.level, max_upgrades)
end
local function onpreload(inst, data)
    if data ~= nil and data.level ~= nil then
        inst.level = data.level
        applyupgrades(inst)
    end
end
local function onsave(inst, data)
    data.level = inst.level > 0 and inst.level or nil
end]]


-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "kurumi.tex" )
	inst:AddTag("kurumi")
	
	--时间值
	
	----网络变量模板----------------------------------------------------(用于封装一个函数, 以后再封装)
	local nettab = {	--填表即可
		maxtimepiont = {"net_shortint", 500},
		currenttimepiont = {"net_shortint", 100},
	}
	local t = 
	{
		net_shortint = net_shortint,
		net_tinybyte = net_tinybyte,
		net_smallbyte = net_smallbyte,
		net_byte = net_byte,
		net_shortint = net_shortint,
		net_ushortint = net_ushortint,
		net_int = net_int,
		net_uint = net_uint,
		net_float = net_float,
		net_hash = net_hash,
		net_string = net_string,
		net_entity = net_entity,
		net_bytearray = net_bytearray,
		net_smallbytearray = net_smallbytearray,
	}
	for k,v in pairs(nettab) do
		if type(v) == "table" then
			inst[k] = t[v[1]](inst.GUID, k, k.."dirty")
			inst[k]:set(v[2])
		end
	end
	--------------------------------------------------------------------

	--[[
	inst.maxtimepiont = net_shortint(inst.GUID,"maxtimepiont","maxtimepiontdirty")
	inst.currenttimepiont = net_shortint(inst.GUID,"currenttimepiont","currenttimepiontdirty")
	inst.maxtimepiont:set(500)
	inst.currenttimepiont:set(0)]]

	
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(200)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.health:SetAbsorptionAmount(.2)
	
	inst.components.sanity.night_drain_mult = 0
	
	--时间值
	inst:AddComponent("kurumi_timepiont")
	
	--inst.level = 0
	--applyupgrades(inst)
	
	----等级表单
	local xishi = 
	{
		[1] = 10,
		[2] = 20,
		[3] = 30,
		[4] = 50,
		[5] = 100,
		[6] = 100,
	}
	
	local xixue = 
	{
		[1] = 1,
		[2] = 5,
		[3] = 10,
		[4] = 13,
		[5] = 20,
		[6] = 30,
	}
	
	local xishi_s = 
	{
		[1] = 12,
		[2] = 13,
		[3] = 15,
		[4] = 23,
		[5] = 44,
		[6] = 56,
	}
	
	--时间监控
	inst:DoPeriodicTask(1, function()
		
		if not inst.components.health:IsDead() and not inst:HasTag("playerghost") then
			--不怕黑
			if inst.Light then
				inst.Light:Enable(true)
				inst.Light:SetRadius(3)
				inst.Light:SetFalloff(.5)
				inst.Light:SetIntensity(0.9)
				inst.Light:SetColour(1,1,1)
			end
			--吸收时间值
			if math.random() < .03 then
				inst.components.kurumi_timepiont:DoDelta( 12 )
			end
			--如果时间值不够那么降低精神
			if inst.components.kurumi_timepiont.currenttimepiont <= 0 then
				inst.components.sanity:DoDelta(-1, true)
			end
		end
		
	end)
	
	--战斗
	inst:ListenForEvent("onhitother",function(inst)
		inst.components.kurumi_timepiont:DoDelta( -10 )
		if math.random() < .2 then
			inst.components.kurumi_timepiont:DoDelta( 10 )
		end
		if math.random() < .2 then
			inst.components.health:DoDelta(1)
		end
	end)
	
	--饥饿变化
	inst:ListenForEvent("hungerdelta", function(inst,data)
		local delta = data.delta
		if delta < 0 and math.random() < .03 then
			inst.components.kurumi_timepiont:DoDelta(-delta)
		end
	end)
	--精神变化
	inst:ListenForEvent("sanitydelta", function(inst,data)
		local delta = (data.newpercent - data.oldpercent) * inst.components.sanity.max
		if delta < 0 and math.random() < .03 then
			inst.components.health:DoDelta(-delta * .05, true)
		end
	end)
	
	--不怕梦魇
	function inst.components.sanity:Recalc(dt)
		local total_dapperness = self.dapperness or 0
		for k, v in pairs(self.inst.components.inventory.equipslots) do
			if v.components.equippable ~= nil then
				total_dapperness = total_dapperness + v.components.equippable:GetDapperness(self.inst)
			end
		end

		total_dapperness = total_dapperness * self.dapperness_mult

		local dapper_delta = total_dapperness * TUNING.SANITY_DAPPERNESS

		local moisture_delta = easing.inSine(self.inst.components.moisture:GetMoisture(), 0, TUNING.MOISTURE_SANITY_PENALTY_MAX, self.inst.components.moisture:GetMaxMoisture())

		local light_delta
		if TheWorld.state.isday and not TheWorld:HasTag("cave") then
			light_delta = TUNING.SANITY_DAY_GAIN
		else
			local lightval = CanEntitySeeInDark(self.inst) and .9 or self.inst.LightWatcher:GetLightValue()
			light_delta =
				(   (lightval > TUNING.SANITY_HIGH_LIGHT and TUNING.SANITY_NIGHT_LIGHT) or
					(lightval < TUNING.SANITY_LOW_LIGHT and TUNING.SANITY_NIGHT_DARK) or
					TUNING.SANITY_NIGHT_MID
				) * self.night_drain_mult
		end

		local aura_delta = 0
		local x, y, z = self.inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, TUNING.SANITY_EFFECT_RANGE, nil, { "FX", "NOCLICK", "DECOR","INLIMBO", "shadowcreature" })
		for i, v in ipairs(ents) do 
			if v.components.sanityaura ~= nil and v ~= self.inst then
				local aura_val = v.components.sanityaura:GetAura(self.inst) / math.max(1, self.inst:GetDistanceSqToInst(v))
				aura_delta = aura_delta + (aura_val < 0 and aura_val * self.neg_aura_mult or aura_val)
			end
		end

		local mount = self.inst.components.rider:IsRiding() and self.inst.components.rider:GetMount() or nil
		if mount ~= nil and mount.components.sanityaura ~= nil then
			local aura_val = mount.components.sanityaura:GetAura(self.inst)
			aura_delta = aura_delta + (aura_val < 0 and aura_val * self.neg_aura_mult or aura_val)
		end

		self:RecalcGhostDrain()
		local ghost_delta = TUNING.SANITY_GHOST_PLAYER_DRAIN * self.ghost_drain_mult

		self.rate = dapper_delta + moisture_delta + light_delta + aura_delta + ghost_delta

		if self.custom_rate_fn ~= nil then
			self.rate = self.rate + self.custom_rate_fn(self.inst)
		end

		self.rate = self.rate * self.rate_modifier
		self.ratescale =
			(self.rate > .2 and RATE_SCALE.INCREASE_HIGH) or
			(self.rate > .1 and RATE_SCALE.INCREASE_MED) or
			(self.rate > .01 and RATE_SCALE.INCREASE_LOW) or
			(self.rate < -.3 and RATE_SCALE.DECREASE_HIGH) or
			(self.rate < -.1 and RATE_SCALE.DECREASE_MED) or
			(self.rate < -.02 and RATE_SCALE.DECREASE_LOW) or
			RATE_SCALE.NEUTRAL

		--print (string.format("dapper: %2.2f light: %2.2f TOTAL: %2.2f", dapper_delta, light_delta, self.rate*dt))
		self:DoDelta(self.rate * dt, true)
	end	
	
	--不被梦魇视为攻击目标
	local old_CanBeAttacked = inst.components.combat.CanBeAttacked
	function inst.components.combat:CanBeAttacked(attacker)
		if attacker and attacker:HasTag("shadowcreature") then
			return false
		else
			return old_CanBeAttacked(self,attacker)
		end
	end
	
	--如果存在分身并且是来自第8技能
	inst:ListenForEvent("death", function(inst,data)
		local x,y,z = attacker.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x,y,z,30,{"kurumi_part"})
		for k,v in pairs(ents) do
			if v and v.components.health and not v.components.health:IsDead() and v.master == inst and v.alive_time == 200 then
				inst:DoTaskInTime(3, function()
					v:Remove()
					inst:PushEvent("respawnfromghost")
					inst:DoTaskInTime(1, function()
						inst.components.health:SetPercent(1)
						inst.components.hunger:SetPercent(1)
						inst.components.sanity:SetPercent(1)
						inst.components.talker:Say("消耗一个分身病满血复活")
					end)
				end)
				break
			end
		end
	end)
	
	--承受攻击来自第12个技能
	local combat = inst.components.combat
	local old_getattacked = combat.GetAttacked
	function combat:GetAttacked(attacker, damage, weapon, stimuli)
		local dmg = damage
		local x,y,z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x,y,z,30,{"kurumi_part"})
		for k, v in pairs(ents) do
			if v and v.components.health and not v.components.health:IsDead() and v.master == inst and v.mode == 1 then
				v.components.combat:GetAttacked(attacker, damage)
				dmg = 0
				break
			end
		end
		return old_getattacked(self, attacker, dmg, weapon, stimuli)
	end
	
	--血量低于20时召唤刻刻帝
	inst:ListenForEvent("healthdelta", function(inst, data)
		if data.oldpercent > .2 and  data.newpercent < .2 then
			--召唤刻刻帝
			local kekedi = SpawnPrefab("kurumi_kekedi")
			kekedi.entity:SetParent(inst.entity)
			
			local down = TheCamera:GetDownVec()
			local angle = math.atan2(down.z, down.x) + PI
			kekedi.Transform:SetPosition( math.cos(angle), 0, -math.sin(angle))
			
			inst.components.health.absorb = .5
			inst:DoTaskInTime(10, function() inst.components.health.absorb = .2 end)
		end
	end)
	
	--inst.OnSave = onsave
    --inst.OnPreLoad = onpreload
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("kurumi", prefabs, assets, common_postinit, master_postinit, start_inv)
