local brain = require "brains/kurumi_self_brain"

local function NormalRetargetFn(inst)
        return FindEntity(inst, TUNING.PIG_TARGET_DIST, function(guy)
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead()
                and inst.components.combat:CanTarget(guy)
        end, nil, { "character" }, nil)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.entity:AddNetwork()
	
	MakeCharacterPhysics(inst, 30, .3)
	
	inst.DynamicShadow:SetSize(2, 1.5)
	
	inst.Transform:SetFourFaced()
	--inst.Transform:SetScale(0.8, 0.8, 0.8)

	inst.AnimState:SetBank("wilson")
	inst.AnimState:SetBuild("kurumi")
	inst.AnimState:PlayAnimation("idle_loop", true)
	inst.AnimState:Show("ARM_carry")
	inst.AnimState:Hide("ARM_normal")
	inst.AnimState:OverrideSymbol("swap_object", "kurumi_gun_swap", "kurumi_gun_swap")
	
	inst:AddTag("kurumi_part")
	
	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end
	
	inst.persists = false
	
	inst:AddComponent("combat")
	inst.components.combat:SetDefaultDamage(33)
	inst.components.combat:SetRange(8, 10)
	inst.components.combat:SetAttackPeriod(2)
	inst.components.combat:SetRetargetFunction(3, NormalRetargetFn)
	
	inst:AddComponent("follower")
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(150)
	--inst.components.health.absorb = 0
	--inst.components.health.fire_damage_scale = 1
	--inst.components.health.invincible = false
	
	inst:AddComponent("inspectable")
	
	inst:AddComponent("locomotor")
	inst.components.locomotor.runspeed = 12
	inst.components.locomotor.walkspeed = 12

	inst:SetBrain(brain)
	inst:SetStateGraph("SGkurumi_self")
	
	inst:DoTaskInTime(inst.alive_time or 20, function()
		if inst then
			inst:Remove()
		end
	end)

	return inst
end

return Prefab("kurumi_self", fn)
