/*
 * Decompiled with CFR 0.152.
 */
package com.viste.realisticarmortiers.events;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.viste.realisticarmortiers.RealisticArmorTiers;
import com.viste.realisticarmortiers.events.Armors;
import com.viste.realisticarmortiers.events.Effects;
import com.viste.realisticarmortiers.events.EventEquipmentGlobalVar;
import com.viste.realisticarmortiers.events.Sets;
import com.viste.realisticarmortiers.events.Tiers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventEquipmentSets {
    public EventEquipmentGlobalVar global;
    public List<Armors> armors = new ArrayList<Armors>();
    private static final Logger log = LogManager.getLogger((String)"realisticarmortiers");

    public EventEquipmentSets() {
        this.global = new EventEquipmentGlobalVar();
        File configDir = new File(new String(RealisticArmorTiers.instance.configFile.getPath() + "/realisticarmortiers/"));
        File jsonConfigTiers = new File(new String(RealisticArmorTiers.instance.configFile.getPath() + "/realisticarmortiers/equipment_tiers.json"));
        File jsonConfigSets = new File(new String(RealisticArmorTiers.instance.configFile.getPath() + "/realisticarmortiers/equipment_sets.json"));
        if (!configDir.exists()) {
            log.info("(Config Folder) Creating /realisticarmortiers/");
            try {
                configDir.mkdir();
            }
            catch (SecurityException se) {
                log.fatal("(Config Folder) Creation Failed");
                log.fatal((Object)se);
                return;
            }
            log.info("(Config Folder) Creation Success");
        } else {
            log.info("(Config Folder) Found /realisticarmortiers/");
        }
        this.copyFile(jsonConfigTiers, "/assets/realisticarmortiers/equipment_tiers.json");
        this.copyFile(jsonConfigSets, "/assets/realisticarmortiers/equipment_sets.json");
        try {
            List sets;
            List tiers;
            log.info("(JSON File) Loading");
            log.info("-> (File Read) Reading JSON files");
            try {
                Gson gson = new Gson();
                BufferedReader brTiers = new BufferedReader(new FileReader(new String(RealisticArmorTiers.instance.configFile.getPath() + "/realisticarmortiers/equipment_tiers.json")));
                Type typeTiers = new TypeToken<List<Tiers>>(){}.getType();
                tiers = (List)gson.fromJson((Reader)brTiers, typeTiers);
                BufferedReader brSets = new BufferedReader(new FileReader(new String(RealisticArmorTiers.instance.configFile.getPath() + "/realisticarmortiers/equipment_sets.json")));
                Type typeSets = new TypeToken<List<Sets>>(){}.getType();
                sets = (List)gson.fromJson((Reader)brSets, typeSets);
            }
            catch (IOException ioe) {
                log.fatal("-> (File Read) Reading Failure");
                log.fatal((Object)ioe);
                return;
            }
            log.info("-> (File Read) Reading Success");
            try {
                log.info("-> (Armors) Loading All");
                for (int i = 0; i < sets.size(); ++i) {
                    float speed = 0.0f;
                    boolean found = false;
                    for (int j = 0; j < tiers.size(); ++j) {
                        if (!((Sets)sets.get((int)i)).set.contentEquals(((Tiers)tiers.get((int)j)).set)) continue;
                        speed = ((Tiers)tiers.get((int)j)).speed;
                        found = true;
                        break;
                    }
                    if (!found) {
                        log.warn("-> -> (Armor Set) " + ((Sets)sets.get((int)i)).set + " was not found in " + "equipment_tiers.json");
                    }
                    List<Effects> effects = ((Sets)sets.get((int)i)).effects;
                    ArrayList<ItemArmor> piecesArmors = new ArrayList<ItemArmor>();
                    for (int j = 0; j < ((Sets)sets.get((int)i)).pieces.size(); ++j) {
                        String path = ((Sets)sets.get((int)i)).modId + ":" + ((Sets)sets.get((int)i)).pieces.get(j);
                        ItemArmor armor = (ItemArmor)ItemArmor.func_111206_d((String)path);
                        if (armor == null) {
                            log.warn("-> -> (Armor Piece) " + ((Sets)sets.get((int)i)).pieces.get(j) + " was not found!");
                            continue;
                        }
                        piecesArmors.add(armor);
                    }
                    this.armors.add(new Armors(this.global, piecesArmors, effects, speed));
                }
                log.info("-> (Armors) Loading Success");
            }
            catch (Exception e) {
                log.fatal("-> (Armors) Loading Failure");
                log.fatal((Object)e);
            }
        }
        catch (Exception e) {
            log.fatal("(JSON File) Loading Failure");
            log.fatal((Object)e);
            return;
        }
        log.info("(JSON File) Loading Success");
    }

    @SubscribeEvent
    public void onArmorUpdate(TickEvent.PlayerTickEvent evt) {
        int j;
        Item armor = null;
        ItemStack stacks = null;
        this.global.setSpeed(0.1f);
        for (j = 0; j < this.armors.size(); ++j) {
            this.armors.get(j).resetPieces();
        }
        for (int i = 0; i < 4; ++i) {
            stacks = evt.player.field_71071_by.func_70440_f(i);
            if (stacks == null) continue;
            armor = stacks.func_77973_b();
            for (j = 0; j < this.armors.size() && !this.armors.get(j).checkArmor(armor, evt); ++j) {
            }
        }
        evt.player.field_71075_bZ.func_82877_b(this.global.getSpeed());
    }

    void copyFile(File file, String asset) {
        if (!file.exists()) {
            log.info("(JSON File) Copying " + asset);
            try {
                int length;
                file.createNewFile();
                InputStream instream = this.getClass().getResourceAsStream(asset);
                FileOutputStream outstream = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((length = instream.read(buffer)) > 0) {
                    outstream.write(buffer, 0, length);
                }
                instream.close();
                outstream.close();
            }
            catch (IOException ioe) {
                log.fatal("(JSON File) Copy Failed");
                log.fatal((Object)ioe);
                return;
            }
            log.info("(JSON File) Copy Success");
        } else {
            log.info("(JSON File) Found " + asset);
        }
    }
}

