﻿<%@ page language="C#" autoeventwireup="true" inherits="ims.infoList, ims.web" enableviewstatemac="false" enableEventValidation="false" %>
<!DOCTYPE html>
<html id="infoList">
<head runat="server">
    <title></title><meta http-equiv="X-UA-Compatible" content="IE=edge" /><meta name="viewport" content="width=device-width,initial-scale=1">
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="sm" runat="server" OnAsyncPostBackError="AsyncError">
        <CompositeScript Path="js/msajax.js" ScriptMode="Release">
            <Scripts>
                <asp:ScriptReference Name="WebForms.js" Assembly="System.Web" /><asp:ScriptReference Name="MicrosoftAjax.js" /><asp:ScriptReference Name="MicrosoftAjaxWebForms.js" />
            </Scripts>
        </CompositeScript>
    </asp:ScriptManager>
    <asp:UpdatePanel ID="listArea" runat="server" ChildrenAsTriggers="false" OnPreRender="ListPreRender" UpdateMode="conditional" RenderMode="Block">
    <ContentTemplate>
        <div runat="server" id="pageTitle" class="pageTitle"></div>
        <div runat="server" id="children" class="clear"></div>
        <div runat="server" id="EmptyPrompt" visible="false" class="highlight"></div>
        <asp:Repeater runat="server" ID="r" OnItemDataBound="ItemBound">
            <ItemTemplate>
                <div class="item">
                    <a runat="server" id="aTitle"></a><img src="images/new.gif" runat="server" id="iconNew" />
                    <div class="summary"><%# Eval("Summary") %></div>
                    <div class="footer">
                        <span runat="server" id="ment"><i class="f-msg5 greenish"></i>评论(<%# Eval("CommentCount") %>)</span><span><i class="f-foot green"></i>浏览(<%# Eval("ClickTimes") %>)</span><span class="f-tag greenish" runat="server" id="tag"></span><span runat="server" id="author"></span>
                        <asp:LinkButton runat="server" ID="ibTop" ToolTip="置顶" OnClick="SetTop" /><asp:LinkButton runat="server" ID="ibDel" OnClick="Del" OnClientClick="return PreDel();" CssClass="toolicon f-close" ToolTip="删除" />
                    </div>
                </div>
            </ItemTemplate>
        </asp:Repeater>
        <div id="pager" runat="server"></div>
        <div id="btns">
            <input type="button" runat="server" id="btnPublish" class="btn" value="发布" onclick="toPublish();" />
            <input type="button" runat="server" id="btnAdvSearch" class="btn" value="搜索" onclick="ShowPop('s_popup');" />
        </div>
        <asp:HiddenField runat="server" ID="curPageIndex" Value="0" /><asp:HiddenField runat="server" ID="filter" Value="" />
        <input type="button" class="hide" runat="server" id="btnFilter" onserverclick="BindList" />
    </ContentTemplate>
    </asp:UpdatePanel>
    <div id="navArea" runat="server">
    <div id="findDiv" class="con middle">
        <input type="text" id="tbKey" runat="server" onkeydown="return enterTo(event,'btnff');" placeholder="标题" /><input type="button" class="btn small rd" id="btnff" value="搜索" onclick="doSearch();" />
    </div>
    <div runat="server" id="cats">
        <div class="titleBlock"><span class="sym f-style"></span> 栏目</div>
        <div class="con">
            <ul runat="server" id="ulCategory" class="ztree">
            </ul>
        </div>
    </div>
    <div class="titleBlock"><span class="sym f-link fat"></span> 相关链接</div>
    <div class="con a_line">
        <ul>
            <li runat="server" id="my"><a onclick="return doFilter('Own');">我发布的<%= ims.Sys.InfoType %></a></li>
            <li runat="server" id="privacy"><a onclick="return doFilter('Private');">我的私人记录</a></li>
            <li runat="server" id="commentBy"><a onclick="return doFilter('CommentBy');">我评论的<%= ims.Sys.InfoType %></a></li>
            <li runat="server" id="today"><a onclick="return doFilter('Today');">今天发布的<%= ims.Sys.InfoType %></a></li>
            <li runat="server" id="yesterday"><a onclick="return doFilter('Yesterday');">昨天发布的<%= ims.Sys.InfoType %></a></li>
            <li runat="server" id="unaudit"><a onclick="return doFilter('UnAudit');">待审核的<%= ims.Sys.InfoType %></a></li>
        </ul>
    </div>
    <div class="titleBlock"><span class="sym f-setting fat"></span> 浏览设置</div>
    <div class="con">
        <ul>
            <li>排序方式：<asp:DropDownList runat="server" ID="ddlSort" OnSelectedIndexChanged="BindList" AutoPostBack="true"><asp:ListItem Value="PublishTime" Selected="True">发布时间</asp:ListItem><asp:ListItem Value="EditTime">修改时间</asp:ListItem><asp:ListItem Value="ClickTimes">浏览次数</asp:ListItem><asp:ListItem Value="LastCommentTime">评论时间</asp:ListItem><asp:ListItem Value="CommentCount">评论数量</asp:ListItem></asp:DropDownList></li>
            <li>每页数量：<asp:DropDownList runat="server" ID="ddlPagesize" OnSelectedIndexChanged="BindList" AutoPostBack="true">
                <asp:ListItem Value="1">1</asp:ListItem>
                <asp:ListItem Value="2">2</asp:ListItem>
                <asp:ListItem Value="3">3</asp:ListItem>
                <asp:ListItem Value="5">5</asp:ListItem>
                <asp:ListItem Value="10">10</asp:ListItem>
                <asp:ListItem Value="15">15</asp:ListItem>
                <asp:ListItem Value="20" Selected="True">20</asp:ListItem>
                <asp:ListItem Value="30">30</asp:ListItem>
                <asp:ListItem Value="50">50</asp:ListItem>
                <asp:ListItem Value="100">100</asp:ListItem>
                <asp:ListItem Value="200">200</asp:ListItem>
                <asp:ListItem Value="300">300</asp:ListItem>
                <asp:ListItem Value="500">500</asp:ListItem>
            </asp:DropDownList></li>
        </ul>
    </div>
    <div class="titleBlock" runat="server" id="tagTitle"><span class="sym f-tag fat"></span> 标签</div>
    <div class="con a_line" id="divTags" runat="server">
    </div>
    </div>    
    <ims:Pop runat="server" ID="s" Title="搜索" Width="390" HideOnOkClientClick="false" OnOkClientClick="return doFilter('Search');" OkButtonText="搜索">
        <ContentTemplate>
            　关键字： <asp:TextBox runat="server" ID="tbKeyword"></asp:TextBox><br />
            　　　　　 <asp:RadioButtonList runat="server" ID="rblField" RepeatLayout="Flow" RepeatDirection="Horizontal"><asp:ListItem Value="Title" Selected="True">标题</asp:ListItem><asp:ListItem Value="All">全文</asp:ListItem></asp:RadioButtonList>
            <div runat="server" id="divType">　　栏目： <asp:RadioButtonList runat="server" ID="rblType" RepeatLayout="Flow" RepeatDirection="Horizontal"><asp:ListItem Value="nolimit" Selected="True">不限</asp:ListItem><asp:ListItem Value=""></asp:ListItem></asp:RadioButtonList><asp:DropDownList runat="server" ID="ddlCats"></asp:DropDownList></div>
            <div runat="server" id="divAuthor">　　作者： <asp:TextBox runat="server" ID="tbAuthor" Width="163"></asp:TextBox></div>
            <div runat="server" id="divRange">　　范围： <asp:RadioButtonList runat="server" ID="rblRange" RepeatLayout="Flow" RepeatDirection="Horizontal"><asp:ListItem Value="Public" Selected="True">公开发布的</asp:ListItem><asp:ListItem Value="Private">我的私人记录</asp:ListItem></asp:RadioButtonList></div>
            <div id="pubTimes">发布时间： <asp:RadioButton runat="server" ID="rbNoLimit" GroupName="Time" Text="不限" Checked="true" /><asp:RadioButton runat="server" ID="rbLimit" GroupName="Time" Text="" /><asp:TextBox runat="server" ID="tbTime1" onfocus="timeChanged(this);"></asp:TextBox>～<asp:TextBox runat="server" ID="tbTime2" onfocus="timeChanged(this);"></asp:TextBox></div>
        </ContentTemplate>
    </ims:Pop>    
    <script src="js/comm.js"></script><script src="js/ztree.js"></script><script src="js/infoList.js"></script>
    </form>
</body>
</html>
