include("InstanceManager");
include("LeaderIcon");
include("PlayerSupport");
include("SupportFunctions");

--local m_kLeaderIM			:table = InstanceManager:new("LeaderInstance", "LeaderContainer", Controls.LeaderStack);
local currentLeader;
local playerTable = {};
function GetLeaderOptions(playerID)
	
	currentLeader = playerID;
	local leaderTypeName :string = PlayerConfigurations[playerID]:GetLeaderTypeName();
	local leaderName :string = Locale.Lookup(GameInfo.Leaders[leaderTypeName].Name);
	playerTable = LoadPlayerTable();
	
	local leaderadded = false;
	for i, v in ipairs(playerTable) do
		if (v.LeaderID == playerID) then
			leaderadded = true
			if v.DealChoice ~= nil then
				Controls.MakeDealCheck:SetSelected(v.DealChoice);
			end
			if v.DemandChoice ~= nil then
				Controls.DemandCheck:SetSelected(v.DemandChoice);
			end
			if v.KudoChoice ~= nil then
				Controls.KudosCheck:SetSelected(v.KudoChoice);
			end
			if v.WarningChoice ~= nil then
				Controls.WarningCheck:SetSelected(v.WarningChoice);
			end
		end		
	end
	local allDeal = GameConfiguration.GetValue("AllDeals");
	local allDemand = GameConfiguration.GetValue("AllDemands");
	local allKudo = GameConfiguration.GetValue("AllKudos");
	local allWarn = GameConfiguration.GetValue("AllWarnings");
	Controls.AllDealCheck:SetSelected(allDeal);
	Controls.AllDemandCheck:SetSelected(allDemand);
	Controls.AllKudosCheck:SetSelected(allKudo);
	Controls.AllWarningCheck:SetSelected(allWarn);
	
	Controls.LeaderName:SetText(leaderName);
	Controls.MakeDealCheck:RegisterCallback( Mouse.eLClick, function() MakeDealCheck(playerID); end );
	Controls.MakeDealCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.DemandCheck:RegisterCallback( Mouse.eLClick, function() DemandCheck(playerID); end );
	Controls.DemandCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.KudosCheck:RegisterCallback( Mouse.eLClick, function() KudosCheck(playerID); end );
	Controls.KudosCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.WarningCheck:RegisterCallback( Mouse.eLClick, function() WarningCheck(playerID); end );
	Controls.WarningCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.AllDealCheck:RegisterCallback( Mouse.eLClick, function() AllDealCheck(playerID); end );
	Controls.AllDealCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.AllDemandCheck:RegisterCallback( Mouse.eLClick, function() AllDemandCheck(playerID); end );
	Controls.AllDemandCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.AllKudosCheck:RegisterCallback( Mouse.eLClick, function() AllKudosCheck(playerID); end );
	Controls.AllKudosCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	Controls.AllWarningCheck:RegisterCallback( Mouse.eLClick, function() AllWarningCheck(playerID); end );
	Controls.AllWarningCheck:RegisterCallback( Mouse.eMouseEnter, function() UI.PlaySound("Main_Menu_Mouse_Over"); end);
	
	
	
	
end

function MakeDealCheck(playerID)
	local isChecked = Controls.MakeDealCheck:IsSelected();
	    Controls.MakeDealCheck:SetSelected(not isChecked);
		for i, v in ipairs(playerTable) do
			if v.LeaderID == playerID then
				v.DealChoice = not isChecked;
			end
		end
		for i, v in ipairs(playerTable) do
			print ("====================================================================================================DealChoice===========",v.LeaderID, v.DealChoice)
		end
		SavePlayerTable(playerTable);
end

function DemandCheck(playerID)
	local isChecked = Controls.DemandCheck:IsSelected();
	    Controls.DemandCheck:SetSelected(not isChecked);
		for i, v in ipairs(playerTable) do
			if v.LeaderID == playerID then
				v.DemandChoice = not isChecked;
			end
		end
		for i, v in ipairs(playerTable) do
			print ("====================================================================================================DemandChoice===========",v.LeaderID, v.DemandChoice)
		end
		SavePlayerTable(playerTable);	

end

function KudosCheck(playerID)
	local isChecked = Controls.KudosCheck:IsSelected();
	    Controls.KudosCheck:SetSelected(not isChecked);
		for i, v in ipairs(playerTable) do
			if v.LeaderID ==  playerID then
				v.KudoChoice = not isChecked;
			end
		end
		for i, v in ipairs(playerTable) do
			print ("====================================================================================================KudoChoice===========",v.LeaderID, v.KudoChoice)
		end
		SavePlayerTable(playerTable);

end

function WarningCheck(playerID)
	local isChecked = Controls.WarningCheck:IsSelected();
	    Controls.WarningCheck:SetSelected(not isChecked);
		for i, v in ipairs(playerTable) do
			if v.LeaderID == playerID then
				v.WarningChoice = not isChecked;
			end
		end
		for i, v in ipairs(playerTable) do
			print ("====================================================================================================WarningChoice===========",v.LeaderID, v.WarningChoice)
		end
		SavePlayerTable(playerTable);


end

function AllDealCheck()
	local isChecked = Controls.AllDealCheck:IsSelected();
	    Controls.AllDealCheck:SetSelected(not isChecked);
	GameConfiguration.SetValue("AllDeals", not isChecked);

end
function AllDemandCheck()
	local isChecked = Controls.AllDemandCheck:IsSelected();
	    Controls.AllDemandCheck:SetSelected(not isChecked);
	GameConfiguration.SetValue("AllDemands", not isChecked);

end
function AllKudosCheck()
	local isChecked = Controls.AllKudosCheck:IsSelected();
	    Controls.AllKudosCheck:SetSelected(not isChecked);
	GameConfiguration.SetValue("AllKudos", not isChecked);

end
function AllWarningCheck()
	local isChecked = Controls.AllWarningCheck:IsSelected();
	    Controls.AllWarningCheck:SetSelected(not isChecked);
	GameConfiguration.SetValue("AllWarnings", not isChecked);

end

function SavePlayerTable(saveTable :table)
	local num = 0;
		for i,v in ipairs(saveTable) do
		num = num + 1;
			local setID =  "Name" .. tostring(i);
			local setDeal =  "Deal" .. tostring(i);
			local setDemand = "Demand" .. tostring(i);
			local setKudo = "Kudo" .. tostring(i);
			local setWarning = "Warning" .. tostring(i);
				GameConfiguration.SetValue(setID, v.LeaderID);
				GameConfiguration.SetValue(setDeal, v.DealChoice);
				GameConfiguration.SetValue(setDemand, v.DemandChoice);
				GameConfiguration.SetValue(setKudo, v.KudoChoice);
				GameConfiguration.SetValue(setWarning, v.WarningChoice);
	
		end
		
	

	
	GameConfiguration.SetValue("PlayerTableCount", num);
	
end

function LoadPlayerTable()
	local num = GameConfiguration.GetValue("PlayerTableCount") or 0;
	local tempQueue :table = {};

	if num > 0 then
		for i= 1, num  do
			local getID =  "Name" .. tostring(i);
			local getDeal =  "Deal" .. tostring(i);
			local getDemand = "Demand" .. tostring(i);
			local getKudo = "Kudo" .. tostring(i);
			local getWarning = "Warning" .. tostring(i);
			local leaderID = GameConfiguration.GetValue(getID);
			local deal = GameConfiguration.GetValue(getDeal);
			local demand = GameConfiguration.GetValue(getDemand);
			local kudo = GameConfiguration.GetValue(getKudo);
			local warning = GameConfiguration.GetValue(getWarning);
			table.insert(tempQueue, {
									LeaderID = leaderID,
									DealChoice = deal,
									DemandChoice = demand,
									KudoChoice = kudo,
									WarningChoice = warning
									});
			
		end

	end

	return tempQueue;


end




function Open()
	ContextPtr:SetHide(false);

end


function OnOpen(playerID)
	Open();
	GetLeaderOptions(playerID);
end 

function Close()
	ContextPtr:SetHide(true);
end
function OnClose()
	Close();

end

function InitializePlayerTable()

	local pMajorPlayers : table = PlayerManager.GetAliveMajors();
	local count = 0;
	for i, pMajorPlayer in ipairs(pMajorPlayers) do
		local iMajorPlayerID : number = pMajorPlayer:GetID();
		if (iMajorPlayerID ~= Game.GetLocalPlayer()) then
			count = count + 1;
			table.insert(playerTable, {
								LeaderID = iMajorPlayerID,
								DealChoice = false,
								DemandChoice = false,
								KudoChoice = false,
								WarningChoice = false
								});
		end
	end	
	SavePlayerTable(playerTable);	
	
	GameConfiguration.SetValue("AllDeals", false);
	GameConfiguration.SetValue("AllDemands", false);
	GameConfiguration.SetValue("AllKudos", false);
	GameConfiguration.SetValue("AllWarnings", false);
	GameConfiguration.SetValue("PlayerTableCount", count);
end

function Initialize()
	
	ContextPtr:SetHide(true);
	Controls.ModalScreenClose:RegisterCallback(Mouse.eLClick, OnClose);
	
	local num = GameConfiguration.GetValue("PlayerTableCount") or 0;
	if num == 0 then InitializePlayerTable(); end
	
	if ( not ExposedMembers.DiploControl) then ExposedMembers.DiploControl = {}; end
	ExposedMembers.DiploControl.OnOpen = OnOpen;	
	ExposedMembers.DiploControl.LoadPlayerTable = LoadPlayerTable;
end
Initialize();