/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.jpdl.internal.activity.JpdlActivity;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinActivity
extends JpdlActivity {
    private static final long serialVersionUID = 1L;
    private LockMode lockMode = LockMode.UPGRADE;
    private Expression multiplicity;

    @Override
    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if ("active-root".equals(execution.getState())) {
            TransitionImpl transition = activity.getDefaultOutgoingTransition();
            if (transition == null) {
                throw new JbpmException("join must have an outgoing transition");
            }
            execution.take(transition);
        } else if ("active-concurrent".equals(execution.getState())) {
            Session session = EnvironmentImpl.getFromCurrent(Session.class);
            session.lock((Object)execution.getParent(), this.lockMode);
            execution.setState("inactive-join");
            execution.waitForSignal();
            ExecutionImpl concurrentRoot = execution.getParent();
            List<ExecutionImpl> joinedExecutions = this.getJoinedExecutions(concurrentRoot, activity);
            if (this.isComplete(execution, joinedExecutions)) {
                this.endExecutions(joinedExecutions);
                if (this.multiplicity != null) {
                    ArrayList<ExecutionImpl> danglingExecutions = new ArrayList<ExecutionImpl>();
                    for (ExecutionImpl concurrentExecution : concurrentRoot.getExecutions()) {
                        if (!"active-concurrent".equals(concurrentExecution.getState())) continue;
                        danglingExecutions.add(concurrentExecution);
                    }
                    this.endExecutions(danglingExecutions);
                }
                ExecutionImpl outgoingExecution = null;
                if (concurrentRoot.getExecutions().isEmpty()) {
                    outgoingExecution = concurrentRoot;
                    outgoingExecution.setState("active-root");
                } else {
                    outgoingExecution = concurrentRoot.createExecution();
                    outgoingExecution.setState("active-concurrent");
                }
                execution.setActivity(activity, outgoingExecution);
                TransitionImpl transition = activity.getDefaultOutgoingTransition();
                if (transition == null) {
                    throw new JbpmException("join must have an outgoing transition");
                }
                outgoingExecution.take(transition);
            }
        } else {
            throw new JbpmException("invalid execution state");
        }
    }

    protected boolean isComplete(ExecutionImpl execution, List<ExecutionImpl> joinedExecutions) {
        int executionsToJoin = this.multiplicity != null ? this.evaluateMultiplicity(execution) : execution.getActivity().getIncomingTransitions().size();
        return joinedExecutions.size() == executionsToJoin;
    }

    protected List<ExecutionImpl> getJoinedExecutions(ExecutionImpl concurrentRoot, Activity activity) {
        ArrayList<ExecutionImpl> joinedExecutions = new ArrayList<ExecutionImpl>();
        Collection<ExecutionImpl> concurrentExecutions = concurrentRoot.getExecutions();
        for (ExecutionImpl concurrentExecution : concurrentExecutions) {
            if (!"inactive-join".equals(concurrentExecution.getState()) || concurrentExecution.getActivity() != activity) continue;
            joinedExecutions.add(concurrentExecution);
        }
        return joinedExecutions;
    }

    protected void endExecutions(List<ExecutionImpl> executions) {
        for (ExecutionImpl execution : executions) {
            execution.end();
        }
    }

    private int evaluateMultiplicity(ExecutionImpl execution) {
        if (this.multiplicity != null) {
            Object value = this.multiplicity.evaluate(execution);
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
        }
        return -1;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public void setMultiplicity(Expression multiplicity) {
        this.multiplicity = multiplicity;
    }
}

