/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.stream.StreamInput;

public class FileStreamInput
extends StreamInput {
    protected File file;

    public FileStreamInput(File file) {
        if (file == null) {
            throw new JbpmException("file is null");
        }
        try {
            this.name = file.toURL().toString();
        }
        catch (MalformedURLException e) {
            this.name = file.toString();
        }
        this.file = file;
    }

    public InputStream openStream() {
        FileInputStream stream = null;
        try {
            if (!this.file.exists()) {
                throw new JbpmException("file " + this.file + " doesn't exist");
            }
            if (this.file.isDirectory()) {
                throw new JbpmException("file " + this.file + " is a directory");
            }
            stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't access file " + this.file + ": " + e.getMessage(), e);
        }
        return stream;
    }
}

