/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.task;

import java.util.List;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.task.LifeCycle;
import org.jbpm.pvm.internal.task.LifeCycleState;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class LifeCycleParser
extends Parser {
    public Object parseDocumentElement(Element element, Parse parse) {
        LifeCycle lifeCycleProcess = new LifeCycle();
        lifeCycleProcess.setName("TaskLifeCycle");
        List<Element> stateElements = XmlUtil.elements(element, "state");
        for (Element stateElement : stateElements) {
            this.parseState(stateElement, lifeCycleProcess, parse);
        }
        for (Element stateElement : stateElements) {
            this.parseTransitions(stateElement, lifeCycleProcess, parse);
        }
        String initialStateName = null;
        if (element.hasAttribute("initial")) {
            initialStateName = element.getAttribute("initial");
            ActivityImpl initial = lifeCycleProcess.getActivity(initialStateName);
            if (initial != null) {
                lifeCycleProcess.setInitial(initial);
            } else {
                parse.addProblem("initial " + initialStateName + " doesn't exist", element);
            }
        }
        return lifeCycleProcess;
    }

    public void parseTransitions(Element element, ProcessDefinitionImpl lifeCycleProcess, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("state doesn't have a name: " + XmlUtil.toString(element), element);
            return;
        }
        String stateName = element.getAttribute("name");
        ActivityImpl state = lifeCycleProcess.getActivity(stateName);
        List<Element> transitionElements = XmlUtil.elements(element, "transition");
        for (Element transitionElement : transitionElements) {
            this.parseTransition(transitionElement, state, parse);
        }
    }

    public void parseTransition(Element element, ActivityImpl state, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("transition doesn't have a name: " + XmlUtil.toString(element), element);
            return;
        }
        String transitionName = element.getAttribute("name");
        if (!element.hasAttribute("to")) {
            parse.addProblem("transition " + transitionName + " doesn't have a to attribute indicating the destination state: " + XmlUtil.toString(element), element);
            return;
        }
        String destinationName = element.getAttribute("to");
        ActivityImpl destination = ((CompositeElementImpl)((Object)state.getProcessDefinition())).getActivity(destinationName);
        if (destination != null) {
            TransitionImpl transition = state.createOutgoingTransition();
            transition.setDestination(destination);
            transition.setName(transitionName);
        } else {
            parse.addProblem("destination " + destinationName + " of " + transitionName + " is unknown", element);
        }
    }

    public void parseState(Element element, ProcessDefinitionImpl lifeCycleProcess, Parse parse) {
        if (!element.hasAttribute("name")) {
            parse.addProblem("state doesn't have an id: " + XmlUtil.toString(element), element);
            return;
        }
        String stateName = element.getAttribute("name");
        ActivityImpl state = lifeCycleProcess.createActivity(stateName);
        state.setActivityBehaviour(new LifeCycleState());
    }
}

