/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.hibernate.cfg.Configuration;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.tx.JtaTransaction;
import org.jbpm.pvm.internal.tx.SpringTransaction;
import org.jbpm.pvm.internal.tx.StandardTransaction;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.StringDescriptor;
import org.jbpm.pvm.internal.wire.operation.FieldOperation;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class TransactionBinding
extends WireDescriptorBinding {
    private static Log log = Log.getLog(TransactionBinding.class.getName());

    public TransactionBinding() {
        super("transaction");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor transactionDescriptor = null;
        String type = "standard";
        if (element.hasAttribute("type")) {
            type = element.getAttribute("type");
        }
        if ("standard".equals(type)) {
            transactionDescriptor = new ObjectDescriptor(StandardTransaction.class);
        } else if ("jta".equals(type)) {
            transactionDescriptor = new ObjectDescriptor(JtaTransaction.class);
            this.autoDetectOrParseAttribute(transactionDescriptor, element);
        } else if ("spring".equals(type)) {
            transactionDescriptor = new ObjectDescriptor(SpringTransaction.class);
        } else {
            parse.addProblem("unsupported transaction type: " + type, element);
        }
        return transactionDescriptor;
    }

    protected void autoDetectOrParseAttribute(ObjectDescriptor transactionDescriptor, Element element) {
        String transactionManagerValue;
        String userTransactionValue;
        if (element.hasAttribute("user-transaction")) {
            userTransactionValue = element.getAttribute("user-transaction");
            if (log.isDebugEnabled()) {
                log.debug("get user-transaction from xml: [" + userTransactionValue + "]");
            }
            this.parseFieldOperation(transactionDescriptor, element, "userTransactionJndiName", userTransactionValue);
        } else {
            userTransactionValue = this.autoDetectHibernateConfiguration("jta.UserTransaction");
            if (userTransactionValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("get user-transaction from hibernate configuration: [" + userTransactionValue + "]");
                }
                this.parseFieldOperation(transactionDescriptor, element, "userTransactionJndiName", userTransactionValue);
            } else if (log.isDebugEnabled()) {
                log.debug("use default user-transaction: [UserTransaction]");
            }
        }
        if (element.hasAttribute("transaction-manager")) {
            transactionManagerValue = element.getAttribute("transaction-manager");
            if (log.isDebugEnabled()) {
                log.debug("get transaction-manager from xml: [" + transactionManagerValue + "]");
            }
            this.parseFieldOperation(transactionDescriptor, element, "transactionManagerJndiName", transactionManagerValue);
        } else {
            transactionManagerValue = this.autoDetectHibernateConfiguration("hibernate.transaction.manager_lookup_class");
            if (log.isDebugEnabled()) {
                log.debug("get transaction-manager from hibernate configuration: [" + transactionManagerValue + "]");
            }
            if (transactionManagerValue != null) {
                this.parseFieldOperation(transactionDescriptor, element, "transactionManagerJndiName", transactionManagerValue);
            } else if (log.isDebugEnabled()) {
                log.debug("use default transaction-manager: [java:/TransactionManager]");
            }
        }
    }

    protected void parseFieldOperation(ObjectDescriptor objectDescriptor, Element element, String fieldName, String fieldValue) {
        FieldOperation fieldOperation = new FieldOperation();
        fieldOperation.setFieldName(fieldName);
        fieldOperation.setDescriptor(new StringDescriptor(fieldValue));
        objectDescriptor.addOperation(fieldOperation);
    }

    protected String autoDetectHibernateConfiguration(String propertyName) {
        Configuration cfg = EnvironmentImpl.getFromCurrent(Configuration.class, false);
        if (cfg == null) {
            return null;
        }
        return cfg.getProperty(propertyName);
    }
}

