/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.descriptor;

import javax.naming.InitialContext;
import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbossIdmIdentitySessionFactoryDescriptor
extends AbstractDescriptor {
    private static final long serialVersionUID = 1L;
    protected String resource = "jbpm.identity.cfg.xml";
    protected String jndiName = null;

    @Override
    public Object construct(WireContext wireContext) {
        if (this.jndiName != null) {
            try {
                InitialContext initialContext = new InitialContext();
                IdentitySessionFactory identitySessionFactory = (IdentitySessionFactory)initialContext.lookup(this.jndiName);
                return identitySessionFactory;
            }
            catch (Exception e) {
                throw new JbpmException("couldn't get idm session factory from jndi address " + this.jndiName, e);
            }
        }
        try {
            return new IdentityConfigurationImpl().configure(this.resource).buildIdentitySessionFactory();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't instanatiate identity session factory: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<?> getType(WireDefinition wireDefinition) {
        return IdentitySessionFactory.class;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }
}

