/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Entity;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final Log log = Log.getLog(Parser.class.getName());
    protected Bindings bindings;
    protected final DocumentBuilderFactory documentBuilderFactory = this.createDocumentBuilderFactory();

    public Parser() {
    }

    public Parser(Bindings bindings) {
        this.bindings = bindings;
    }

    @Deprecated
    public Parser(Bindings bindings, Map<String, Entity> entities) {
        this.bindings = bindings;
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        factory.setIgnoringComments(true);
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(Parse parse) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(parse);
            parse.documentBuilder = documentBuilder;
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            parse.addProblem("could not create document builder", e);
            return null;
        }
    }

    public void setSchemaResources(String ... schemaResources) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String[] schemaSources = new String[schemaResources.length];
        for (int i = 0; i < schemaResources.length; ++i) {
            String schemaResource = schemaResources[i];
            URL schemaLocation = classLoader.getResource(schemaResource);
            if (schemaLocation != null) {
                log.info("loading schema resource: " + schemaResource);
                schemaSources[i] = schemaLocation.toString();
                continue;
            }
            log.warn("skipping unavailable schema resource: " + schemaResource);
        }
        this.documentBuilderFactory.setValidating(true);
        try {
            this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            this.documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSources);
        }
        catch (IllegalArgumentException e) {
            log.warn("JAXP implementation does not support XML Schema, XML documents will not be checked for grammar errors", e);
        }
        try {
            this.documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            log.warn("JAXP implementation is not Xerces, cannot enable dynamic validation, XML documents without schema location will not parse", e);
        }
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public Binding getBinding(Element element) {
        return this.getBinding(element, null);
    }

    public Binding getBinding(Element element, String category) {
        return this.bindings != null ? this.bindings.getBinding(element, category) : null;
    }

    public Parse createParse() {
        return new Parse(this);
    }

    public void importStream(StreamInput importedStreamInput, Element destination, Parse importingParse) {
        try {
            Parse importedParse = this.createParse();
            importedParse.setStreamSource(importedStreamInput);
            Document importedDocument = this.buildDocument(importedParse);
            Element importedDocumentElement = importedDocument.getDocumentElement();
            for (Element e : XmlUtil.elements(importedDocumentElement)) {
                destination.appendChild(destination.getOwnerDocument().importNode(e, true));
            }
            importedParse.checkErrors(destination.getTagName());
        }
        catch (Exception e) {
            importingParse.addProblem("could not import " + importedStreamInput, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Parse parse) {
        try {
            if (parse.document == null) {
                parse.document = this.buildDocument(parse);
            }
            if (parse.document != null) {
                try {
                    this.parseDocument(parse.document, parse);
                }
                catch (Exception e) {
                    parse.addProblem("parsing exception: " + e.getMessage(), e);
                }
            }
        }
        finally {
            if (parse.inputStream != null) {
                try {
                    parse.inputStream.close();
                }
                catch (Exception e) {
                    parse.addProblem("couldn't close input stream", e);
                }
            }
        }
    }

    protected Document buildDocument(Parse parse) {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(parse);
        InputSource inputSource = parse.getInputSource();
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (IOException e) {
            parse.addProblem("could not read input", e);
        }
        catch (SAXException e) {
            parse.addProblem("failed to parse xml", e);
        }
        return null;
    }

    public Object parseDocument(Document document, Parse parse) {
        Object object;
        parse.documentObject = object = this.parseDocumentElement(document.getDocumentElement(), parse);
        return object;
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        return this.parseElement(documentElement, parse);
    }

    public Object parseElement(Element element, Parse parse) {
        return this.parseElement(element, parse, null);
    }

    public Object parseElement(Element element, Parse parse, String category) {
        Object object = null;
        String tagName = element.getLocalName();
        Binding binding = this.getBinding(element, category);
        if (binding != null) {
            object = binding.parse(element, parse, this);
        } else if (log.isDebugEnabled()) {
            log.debug("no element parser for tag " + tagName + (category != null ? " in category " + category : " in the default category"));
        }
        return object;
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse) {
        return this.parseArgs(argElements, parse, "descriptor");
    }

    public List<ArgDescriptor> parseArgs(List<Element> argElements, Parse parse, String category) {
        ArrayList<ArgDescriptor> args = null;
        if (argElements != null) {
            if (argElements.size() > 0) {
                args = new ArrayList<ArgDescriptor>(argElements.size());
            }
            for (Element argElement : argElements) {
                ArgDescriptor argDescriptor = new ArgDescriptor();
                argDescriptor.setTypeName(XmlUtil.attribute(argElement, "type"));
                Element descriptorElement = XmlUtil.element(argElement);
                if (descriptorElement == null) {
                    parse.addProblem("arg must contain exactly one descriptor element out of " + this.bindings.getTagNames(category) + " as contents:" + XmlUtil.toString(argElement.getParentNode()), argElement);
                } else {
                    Descriptor descriptor = (Descriptor)this.parseElement(descriptorElement, parse, category);
                    argDescriptor.setDescriptor(descriptor);
                }
                args.add(argDescriptor);
            }
        }
        return args;
    }
}

