/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jbpm.api.Configuration;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.task.Task;
import org.jbpm.test.BaseJbpmTestCase;
import org.jbpm.test.Db;
import org.jbpm.test.JmsExtensions;
import org.jbpm.test.JmsNonXATopicListener;
import org.jbpm.test.JmsTopicListener;
import org.jbpm.test.JmsXATopicListener;
import org.jbpm.test.assertion.CollectionAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JbpmTestCase
extends BaseJbpmTestCase {
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected ExecutionService executionService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected List<String> registeredDeployments;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.processEngine = this.buildProcessEngine();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.executionService = this.processEngine.getExecutionService();
        this.historyService = this.processEngine.getHistoryService();
        this.managementService = this.processEngine.getManagementService();
        this.taskService = this.processEngine.getTaskService();
        this.identityService = this.processEngine.getIdentityService();
    }

    protected ProcessEngine buildProcessEngine() {
        return Configuration.getProcessEngine();
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteRegisteredDeployments();
        String errorMsg = this.verifyDbClean();
        super.tearDown();
        if (errorMsg != null) {
            throw new JbpmException(errorMsg);
        }
    }

    public static void jmsCreateQueue(String connectionFactoryJndiName, String queueJndiName) {
        JmsExtensions.createQueue(connectionFactoryJndiName, queueJndiName);
    }

    public static Object jmsConsumeMessageFromQueue(String connectionFactoryJndiName, String queueJndiName) {
        return JbpmTestCase.jmsConsumeMessageFromQueue(connectionFactoryJndiName, queueJndiName, 1000L, true, 1);
    }

    public static Object jmsConsumeMessageFromQueue(String connectionFactoryJndiName, String queueJndiName, long timeout, boolean transacted, int acknowledgeMode) {
        return JmsExtensions.consumeMessageFromQueue(connectionFactoryJndiName, queueJndiName, timeout, transacted, acknowledgeMode);
    }

    public static Object jmsConsumeMessageFromQueueXA(String connectionFactoryJndiName, String queueJndiName, long timeout) {
        return JmsExtensions.consumeMessageFromQueueXA(connectionFactoryJndiName, queueJndiName, timeout);
    }

    public static void jmsAssertQueueEmpty(String connectionFactoryJndiName, String queueJndiName, long timeout, boolean transacted, int acknowledgeMode) {
        JmsExtensions.jmsAssertQueueEmpty(connectionFactoryJndiName, queueJndiName, timeout, transacted, acknowledgeMode);
    }

    public static void jmsAssertQueueEmptyXA(String connectionFactoryJndiName, String queueJndiName, long timeout) {
        JmsExtensions.jmsAssertQueueEmptyXA(connectionFactoryJndiName, queueJndiName, timeout);
    }

    public static void jmsRemoveQueue(String connectionFactoryJndiName, String queueJndiName) {
        JmsExtensions.removeQueue(connectionFactoryJndiName, queueJndiName);
    }

    public static void jmsCreateTopic(String connectionFactoryJndiName, String topicJndiName) {
        JmsExtensions.createTopic(connectionFactoryJndiName, topicJndiName);
    }

    public static JmsTopicListener jmsStartTopicListener(String connectionFactoryJndiName, String topicJndiName, boolean transacted, int acknowledgeMode) {
        return new JmsNonXATopicListener(connectionFactoryJndiName, topicJndiName, transacted, acknowledgeMode);
    }

    public static JmsTopicListener jmsStartTopicListenerXA(String connectionFactoryJndiName, String topicJndiName) {
        return new JmsXATopicListener(connectionFactoryJndiName, topicJndiName);
    }

    public static void jmsRemoveTopic(String connectionFactoryJndiName, String topicJndiName) {
        JmsExtensions.removeTopic(connectionFactoryJndiName, topicJndiName);
    }

    protected String verifyDbClean() {
        String errorMsg = null;
        String recordsLeftMsg = Db.verifyClean(this.processEngine);
        if (recordsLeftMsg != null && recordsLeftMsg.length() > 0) {
            errorMsg = "database was not clean after test: " + recordsLeftMsg;
        }
        return errorMsg;
    }

    protected void deleteRegisteredDeployments() {
        if (this.registeredDeployments != null) {
            for (String deploymentId : this.registeredDeployments) {
                this.repositoryService.deleteDeploymentCascade(deploymentId);
            }
        }
    }

    public String deployFromClasspath(String resourceName) {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromClasspath(resourceName).deploy();
        this.registerDeployment(deploymentDbid);
        return deploymentDbid;
    }

    public String deployJpdlXmlString(String jpdlXmlString) {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", jpdlXmlString).deploy();
        this.registerDeployment(deploymentDbid);
        return deploymentDbid;
    }

    public String deployBpmn2XmlString(String bpmn2XmlString) {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.bpmn.xml", bpmn2XmlString).deploy();
        this.registerDeployment(deploymentDbid);
        return deploymentDbid;
    }

    protected void registerDeployment(String deploymentId) {
        if (this.registeredDeployments == null) {
            this.registeredDeployments = new ArrayList<String>();
        }
        this.registeredDeployments.add(deploymentId);
    }

    public static void assertContainsTask(List<Task> taskList, String taskName) {
        if (JbpmTestCase.getTask(taskList, taskName) == null) {
            JbpmTestCase.fail((String)("tasklist doesn't contain task '" + taskName + "': " + taskList));
        }
    }

    public static void assertContainsTask(List<Task> taskList, String taskName, String assignee) {
        if (JbpmTestCase.getTask(taskList, taskName, assignee) == null) {
            JbpmTestCase.fail((String)("tasklist doesn't contain task '" + taskName + "' for assignee '" + assignee + "': " + taskList));
        }
    }

    public static Task getTask(List<Task> taskList, String taskName) {
        for (Task task : taskList) {
            if (!taskName.equals(task.getName())) continue;
            return task;
        }
        return null;
    }

    public static Task getTask(List<Task> taskList, String taskName, String assignee) {
        for (Task task : taskList) {
            if (!taskName.equals(task.getName()) || !(assignee == null ? task.getAssignee() == null : assignee.equals(task.getAssignee()))) continue;
            return task;
        }
        return null;
    }

    public void assertNoOpenTasks(String processInstanceId) {
        List<Task> tasks = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        JbpmTestCase.assertTrue((String)("There were still open tasks found for the process instance with id " + processInstanceId + ". Current tasks are: " + this.listAllOpenTasks(processInstanceId)), (boolean)tasks.isEmpty());
    }

    protected String listAllOpenTasks(String processInstanceId) {
        List<Task> tasks = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        StringBuilder result = new StringBuilder();
        for (Task task : tasks) {
            result.append("'" + task.getName() + "', ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public void assertExecutionEnded(String processInstanceId) {
        JbpmTestCase.assertNull((String)("Error: an active process instance with id " + processInstanceId + " was found"), (Object)this.executionService.findProcessInstanceById(processInstanceId));
    }

    public void assertProcessInstanceEnded(String processInstanceId) {
        this.assertExecutionEnded(processInstanceId);
    }

    public void assertProcessInstanceEnded(ProcessInstance processInstance) {
        this.assertExecutionEnded(processInstance.getId());
    }

    public void assertProcessInstanceActive(ProcessInstance processInstance) {
        this.assertProcessInstanceActive(processInstance.getId());
    }

    public void assertProcessInstanceActive(String processInstanceId) {
        JbpmTestCase.assertNotNull((String)("Error: an active process instance with id " + processInstanceId + " was not found"), (Object)this.executionService.findProcessInstanceById(processInstanceId));
    }

    public void assertActivityActive(String executionId, String activityName) {
        JbpmTestCase.assertTrue((String)("The execution with id '" + executionId + "' is not active in the activity '" + activityName + "'." + "Current activitites are: " + this.listAllActiveActivites(executionId)), (boolean)this.executionService.findExecutionById(executionId).isActive(activityName));
    }

    public void assertNotActivityActive(String executionId, String activityName) {
        Execution execution = this.executionService.findExecutionById(executionId);
        JbpmTestCase.assertFalse((boolean)execution.isActive(activityName));
    }

    public void assertActivitiesActive(String executionId, String ... activityNames) {
        CollectionAssertions.assertContainsSameElements(this.executionService.findExecutionById(executionId).findActiveActivityNames(), activityNames);
    }

    public void assertExecutionInOneOrMoreActivitiesActive(String executionId, String ... activityNames) {
        boolean inOneActivityActive = false;
        Execution execution = this.executionService.findExecutionById(executionId);
        for (String activityName : activityNames) {
            if (!execution.isActive(activityName)) continue;
            inOneActivityActive = true;
        }
        JbpmTestCase.assertTrue((String)("The execution with id '" + executionId + "' is not active in one of these activities: " + activityNames + "Current activitites are: " + this.listAllActiveActivites(executionId)), (boolean)inOneActivityActive);
    }

    protected String listAllActiveActivites(String executionId) {
        Execution execution = this.executionService.findExecutionById(executionId);
        Set<String> activeActivities = execution.findActiveActivityNames();
        StringBuilder result = new StringBuilder();
        for (String activeActivity : activeActivities) {
            result.append("'" + activeActivity + "', ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillNoMoreMessages() {
        long timeout = 60000L;
        long checkInterval = 1000L;
        TimerTask interruptTask = new TimerTask(){
            Thread testThread = Thread.currentThread();

            public void run() {
                JbpmTestCase.this.log.debug("test " + JbpmTestCase.this.getName() + " took too long. going to interrupt..." + this.testThread);
                this.testThread.interrupt();
            }
        };
        Timer timer = new Timer();
        timer.schedule(interruptTask, 60000L);
        try {
            int jobCount;
            while ((jobCount = this.getJobCount()) > 0) {
                this.log.debug("waiting 1000 ms for " + jobCount + " jobs to execute");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            JbpmTestCase.fail((String)"test execution exceeded treshold of 60000 milliseconds");
        }
        finally {
            timer.cancel();
        }
    }

    protected int getJobCount() {
        return this.processEngine.execute(new Command<Integer>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Integer execute(Environment environment) {
                Session session = environment.get(Session.class);
                return (Integer)session.createCriteria("org.jbpm.pvm.internal.job.JobImpl").add((Criterion)Restrictions.gt((String)"retries", (Object)0)).setProjection(Projections.rowCount()).uniqueResult();
            }
        });
    }
}

