/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.client;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import sun.net.www.ParseUtil;
import sun.plugin.liveconnect.JavaScriptProtectionDomain;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.liveconnect.ArgumentHelper;
import sun.plugin2.liveconnect.BrowserSideObject;
import sun.plugin2.liveconnect.JavaClass;
import sun.plugin2.liveconnect.JavaNameSpace;
import sun.plugin2.liveconnect.JavaProxy;
import sun.plugin2.liveconnect.RemoteJavaObject;
import sun.plugin2.main.client.MessagePassingJSObject;
import sun.plugin2.message.JavaObjectOpMessage;
import sun.plugin2.message.JavaReplyMessage;
import sun.plugin2.message.JavaScriptReleaseObjectMessage;
import sun.plugin2.message.Pipe;
import sun.plugin2.util.SystemUtil;

public class LiveConnectSupport {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static Pipe pipe;
    private static int jvmID;
    private static ReferenceQueue queue;
    private static volatile boolean shouldStop;
    private static Thread cleanupThread;
    private static Map refCounts;
    private static Map exportedObjectMap;
    private static Map objectIDMap;
    private static int nextObjectID;
    private static Map appletInfoMap;

    private LiveConnectSupport() {
    }

    public static void initialize(Pipe pipe, int n) {
        LiveConnectSupport.pipe = pipe;
        jvmID = n;
        cleanupThread = new BrowserSideObjectCleanupThread();
        cleanupThread.start();
    }

    public static void shutdown() {
        shouldStop = true;
        cleanupThread.interrupt();
    }

    public static synchronized void appletStarted(int n, Plugin2Manager plugin2Manager) {
        appletInfoMap.put(new Integer(n), new PerAppletInfo(n, plugin2Manager));
    }

    public static synchronized void appletStopped(int n) {
        PerAppletInfo perAppletInfo = (PerAppletInfo)appletInfoMap.remove(new Integer(n));
        if (perAppletInfo != null) {
            perAppletInfo.stop();
        }
    }

    public static Object exportObject(Object object, int n, boolean bl, boolean bl2) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object) && !bl) {
            return object;
        }
        if (object instanceof MessagePassingJSObject) {
            return ((MessagePassingJSObject)object).getBrowserSideObject();
        }
        return LiveConnectSupport.exportRemoteObject(object, n, bl2);
    }

    public static Object importObject(Object object, int n) {
        if (object == null) {
            return object;
        }
        if (ArgumentHelper.isPrimitiveOrString(object)) {
            return object;
        }
        if (object instanceof BrowserSideObject) {
            BrowserSideObject browserSideObject = (BrowserSideObject)object;
            MessagePassingJSObject messagePassingJSObject = new MessagePassingJSObject(browserSideObject, n, pipe);
            LiveConnectSupport.ref(browserSideObject, n);
            LiveConnectSupport.track(messagePassingJSObject);
            return messagePassingJSObject;
        }
        if (object instanceof RemoteJavaObject) {
            return LiveConnectSupport.importRemoteObject((RemoteJavaObject)object);
        }
        throw new IllegalArgumentException("Unsupported argument type " + object.getClass().getName());
    }

    public static synchronized void doObjectOp(JavaObjectOpMessage javaObjectOpMessage) throws IOException {
        RemoteJavaObject remoteJavaObject = javaObjectOpMessage.getObject();
        PerAppletInfo perAppletInfo = LiveConnectSupport.getInfo(remoteJavaObject.getAppletID());
        if (perAppletInfo != null) {
            if (javaObjectOpMessage.getConversation() == null) {
                perAppletInfo.enqueue(javaObjectOpMessage);
            } else {
                perAppletInfo.doObjectOp(javaObjectOpMessage);
            }
        } else {
            pipe.send(new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, "Applet ID " + remoteJavaObject.getAppletID() + " is not registered in this JVM instance"));
        }
    }

    public static synchronized void releaseRemoteObject(RemoteJavaObject remoteJavaObject) {
        Integer n = new Integer(remoteJavaObject.getObjectID());
        Object v = objectIDMap.remove(n);
        if (v != null) {
            exportedObjectMap.remove(v);
        }
    }

    private static synchronized void ref(BrowserSideObject browserSideObject, int n) {
        BrowserSideObjectKey browserSideObjectKey = new BrowserSideObjectKey(browserSideObject, n);
        ReferenceCount referenceCount = (ReferenceCount)refCounts.get(browserSideObjectKey);
        if (referenceCount == null) {
            referenceCount = new ReferenceCount();
            refCounts.put(browserSideObjectKey, referenceCount);
        }
        referenceCount.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unref(BrowserSideObjectKey browserSideObjectKey) throws IOException {
        boolean bl = false;
        Class clazz = LiveConnectSupport.class;
        synchronized (clazz) {
            ReferenceCount referenceCount = (ReferenceCount)refCounts.get(browserSideObjectKey);
            if (referenceCount == null) {
                return;
            }
            if (referenceCount.unref() == 0) {
                refCounts.remove(browserSideObjectKey);
                bl = true;
            }
        }
        if (bl) {
            pipe.send(new JavaScriptReleaseObjectMessage(null, browserSideObjectKey.getObject(), browserSideObjectKey.getAppletID()));
        }
    }

    private static void track(MessagePassingJSObject messagePassingJSObject) {
        new BrowserSideObjectReference(messagePassingJSObject, queue, new BrowserSideObjectKey(messagePassingJSObject.getBrowserSideObject(), messagePassingJSObject.getAppletID()));
    }

    private static synchronized RemoteJavaObject exportRemoteObject(Object object, int n, boolean bl) {
        RemoteJavaObject remoteJavaObject = (RemoteJavaObject)exportedObjectMap.get(object);
        if (remoteJavaObject != null && !LiveConnectSupport.isAppletRunning(remoteJavaObject.getAppletID())) {
            LiveConnectSupport.releaseRemoteObject(remoteJavaObject);
            remoteJavaObject = null;
        }
        if (remoteJavaObject == null) {
            int n2 = ++nextObjectID;
            remoteJavaObject = new RemoteJavaObject(jvmID, n, n2, bl);
            exportedObjectMap.put(object, remoteJavaObject);
            objectIDMap.put(new Integer(n2), object);
        }
        return remoteJavaObject;
    }

    private static synchronized Object importRemoteObject(RemoteJavaObject remoteJavaObject) {
        return objectIDMap.get(new Integer(remoteJavaObject.getObjectID()));
    }

    private static synchronized PerAppletInfo getInfo(int n) {
        return (PerAppletInfo)appletInfoMap.get(new Integer(n));
    }

    private static boolean isAppletRunning(int n) {
        return LiveConnectSupport.getInfo(n) != null;
    }

    private static AccessControlContext createContext(URL uRL) {
        try {
            ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{LiveConnectSupport.getJSProtectionDomain(uRL)};
            return new AccessControlContext(protectionDomainArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ProtectionDomain getJSProtectionDomain(URL uRL) throws MalformedURLException {
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        final PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        Plugin2ClassLoader.addDefaultPermissions(permissionCollection);
        if (uRL != null) {
            Permission permission;
            String string = null;
            try {
                permission = uRL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                permission = null;
            }
            if (permission instanceof FilePermission) {
                string = permission.getName();
            } else if (permission == null && uRL.getProtocol().equals("file")) {
                string = uRL.getFile().replace('/', File.separatorChar);
                string = ParseUtil.decode(string);
            } else if (permission instanceof SocketPermission) {
                String string2 = uRL.getHost();
                if (string2 == null || string2.equals("")) {
                    try {
                        string2 = new URL(uRL.getFile()).getHost();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (string2 != null && !string2.equals("")) {
                    permissionCollection.add(new SocketPermission(string2, "connect,accept"));
                }
            }
            if (string != null) {
                if (string.endsWith(File.separator)) {
                    string = string + "-";
                } else {
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        string = string.substring(0, n + 1) + "-";
                    }
                }
                permissionCollection.add(new FilePermission(string, "read"));
                permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            String string = InetAddress.getLocalHost().getHostName();
                            permissionCollection.add(new SocketPermission(string, "connect,accept"));
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
        }
        return new JavaScriptProtectionDomain(permissionCollection);
    }

    private static String getOpName(int n) {
        switch (n) {
            case 1: {
                return "CALL_METHOD";
            }
            case 2: {
                return "GET_FIELD";
            }
            case 3: {
                return "SET_FIELD";
            }
            case 4: {
                return "HAS_FIELD";
            }
            case 5: {
                return "HAS_METHOD";
            }
        }
        throw new IllegalArgumentException("Invalid operation kind " + n);
    }

    static {
        queue = new ReferenceQueue();
        refCounts = new HashMap();
        exportedObjectMap = new IdentityHashMap();
        objectIDMap = new HashMap();
        appletInfoMap = new HashMap();
    }

    private static class BrowserSideObjectCleanupThread
    extends Thread {
        public BrowserSideObjectCleanupThread() {
            super("Browser Side Object Cleanup Thread");
        }

        public void run() {
            while (!shouldStop) {
                try {
                    BrowserSideObjectReference browserSideObjectReference = (BrowserSideObjectReference)queue.remove();
                    LiveConnectSupport.unref(browserSideObjectReference.getObjectKey());
                }
                catch (IOException iOException) {
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static class BrowserSideObjectKey {
        private BrowserSideObject object;
        private int appletID;

        public BrowserSideObjectKey(BrowserSideObject browserSideObject, int n) {
            this.object = browserSideObject;
            this.appletID = n;
        }

        public BrowserSideObject getObject() {
            return this.object;
        }

        public int getAppletID() {
            return this.appletID;
        }

        public int hashCode() {
            return this.object.hashCode() ^ this.appletID;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            BrowserSideObjectKey browserSideObjectKey = (BrowserSideObjectKey)object;
            return this.object.equals(browserSideObjectKey.object) && this.appletID == browserSideObjectKey.appletID;
        }
    }

    private static class BrowserSideObjectReference
    extends PhantomReference {
        private BrowserSideObjectKey objectKey;

        public BrowserSideObjectReference(Object object, ReferenceQueue referenceQueue, BrowserSideObjectKey browserSideObjectKey) {
            super(object, referenceQueue);
            this.objectKey = browserSideObjectKey;
        }

        public BrowserSideObjectKey getObjectKey() {
            return this.objectKey;
        }
    }

    private static class PerAppletInfo {
        private int appletID;
        private Plugin2Manager manager;
        private LiveConnectWorker worker;
        private boolean fetchedDocumentBase;
        private URL documentBase;
        private AccessControlContext context;
        private volatile boolean notifiedOfStart;
        private Map classes = new HashMap();
        private Set notJavaClasses = new HashSet();

        public PerAppletInfo(int n, Plugin2Manager plugin2Manager) {
            this.appletID = n;
            this.manager = plugin2Manager;
            this.worker = new LiveConnectWorker();
            plugin2Manager.startWorkerThread("Applet " + n + " LiveConnect Worker Thread", this.worker);
        }

        public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
            this.worker.enqueue(javaObjectOpMessage);
        }

        public void stop() {
            this.worker.stop();
        }

        public void doObjectOp(final JavaObjectOpMessage javaObjectOpMessage) throws IOException {
            JavaReplyMessage javaReplyMessage = null;
            try {
                this.waitForAppletStartOrError();
                if (this.manager.hasErrorOccurred()) {
                    if (this.manager.getErrorMessage() != null) {
                        throw new RuntimeException(this.manager.getErrorMessage());
                    }
                    if (this.manager.getErrorException() != null) {
                        throw (IOException)new IOException().initCause(this.manager.getErrorException());
                    }
                }
                final Object object = LiveConnectSupport.importObject(javaObjectOpMessage.getObject(), this.appletID);
                final Object[] objectArray = javaObjectOpMessage.getArguments();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = LiveConnectSupport.importObject(objectArray[i], this.appletID);
                    }
                }
                final JavaProxy javaProxy = this.getJavaProxy(object);
                Object var6_10 = null;
                final boolean[] blArray = new boolean[1];
                final boolean bl = javaObjectOpMessage.getObject().isApplet();
                boolean bl2 = false;
                if (DEBUG) {
                    System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\"");
                }
                switch (javaObjectOpMessage.getOperationKind()) {
                    case 1: {
                        var6_10 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return javaProxy.invoke(javaObjectOpMessage.getMemberName(), object, objectArray, blArray, bl);
                            }
                        }, this.getContext());
                        if (var6_10 != Void.TYPE) break;
                        bl2 = true;
                        var6_10 = null;
                        break;
                    }
                    case 2: {
                        var6_10 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return javaProxy.getField(javaObjectOpMessage.getMemberName(), object, blArray, bl);
                            }
                        }, this.getContext());
                        break;
                    }
                    case 3: {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                javaProxy.setField(javaObjectOpMessage.getMemberName(), object, objectArray[0], bl);
                                return null;
                            }
                        }, this.getContext());
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        var6_10 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return javaProxy.hasField(javaObjectOpMessage.getMemberName(), object, bl) ? Boolean.TRUE : Boolean.FALSE;
                            }
                        }, this.getContext());
                        break;
                    }
                    case 5: {
                        var6_10 = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return javaProxy.hasMethod(javaObjectOpMessage.getMemberName(), object, bl) ? Boolean.TRUE : Boolean.FALSE;
                            }
                        }, this.getContext());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal error: unknown Java object operation " + javaObjectOpMessage.getOperationKind());
                    }
                }
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), LiveConnectSupport.exportObject(var6_10, this.appletID, blArray[0], false), bl2, null);
                if (DEBUG) {
                    System.out.println("LiveConnectSupport: " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " \"" + javaObjectOpMessage.getMemberName() + "\": returning result " + var6_10);
                }
            }
            catch (Exception exception) {
                Object object;
                Exception exception2;
                if (DEBUG) {
                    System.out.println("Exception occurred during " + LiveConnectSupport.getOpName(javaObjectOpMessage.getOperationKind()) + " " + javaObjectOpMessage.getMemberName() + ":");
                    exception.printStackTrace();
                }
                if (exception instanceof PrivilegedActionException) {
                    exception2 = ((PrivilegedActionException)exception).getException();
                }
                if (exception2 instanceof InvocationTargetException && (object = ((InvocationTargetException)exception2).getTargetException()) instanceof Exception) {
                    exception2 = (Exception)object;
                }
                object = exception2.toString();
                javaReplyMessage = new JavaReplyMessage(javaObjectOpMessage.getConversation(), javaObjectOpMessage.getResultID(), null, false, (String)object);
            }
            pipe.send(javaReplyMessage);
        }

        private AccessControlContext getContext() {
            if (this.context == null) {
                this.context = LiveConnectSupport.createContext(this.getDocumentBase());
            }
            return this.context;
        }

        private URL getDocumentBase() {
            if (!this.fetchedDocumentBase) {
                this.documentBase = this.manager.getDocumentBase();
                this.fetchedDocumentBase = true;
            }
            return this.documentBase;
        }

        private JavaProxy getJavaProxy(Object object) {
            if (object instanceof JavaNameSpace) {
                return new JavaNameSpaceProxy();
            }
            return this.getJavaClass(object.getClass());
        }

        private synchronized JavaClass getJavaClass(Class clazz) {
            JavaClass javaClass = (JavaClass)this.classes.get(clazz);
            if (javaClass == null) {
                javaClass = new JavaClass(clazz);
                this.classes.put(clazz, javaClass);
            }
            return javaClass;
        }

        private void waitForAppletStartOrError() throws IOException {
            if (this.manager.getApplet() != null || this.manager.hasErrorOccurred()) {
                this.manager.waitUntilAppletInitDone();
                return;
            }
            if (this.manager.isForDummyApplet()) {
                return;
            }
            throw new IOException("LiveConnect operation without existing applet");
        }

        class JavaNameSpaceProxy
        implements JavaProxy {
            JavaNameSpaceProxy() {
            }

            public Object invoke(String string, Object object, Object[] objectArray, boolean[] blArray, boolean bl) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                JavaClass javaClass = this.getJavaClass(javaNameSpace.getName(), false);
                if (javaClass == null) {
                    if ("toString".equalsIgnoreCase(string)) {
                        return "[Java Package \"" + javaNameSpace.getName() + "\"]";
                    }
                    throw new ClassNotFoundException(javaNameSpace.getName());
                }
                if (string.equals("<init>")) {
                    if (blArray != null) {
                        blArray[0] = true;
                    }
                    return javaClass.newInstance(objectArray);
                }
                return javaClass.invoke(string, null, objectArray, blArray, bl);
            }

            public Object getField(String string, Object object, boolean[] blArray, boolean bl) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                JavaClass javaClass = this.getJavaClass(string2, false);
                if (javaClass != null) {
                    return javaClass.getField(string, null, blArray, bl);
                }
                if (string2 == null || string2.equals("")) {
                    return new JavaNameSpace(string);
                }
                return new JavaNameSpace(string2 + "." + string);
            }

            public void setField(String string, Object object, Object object2, boolean bl) throws Exception {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                JavaClass javaClass = this.getJavaClass(string2, false);
                if (javaClass == null) {
                    throw new UnsupportedOperationException("Can not perform a setField operation on a JavaNameSpace");
                }
                javaClass.setField(string, null, object2, bl);
            }

            public boolean hasField(String string, Object object, boolean bl) {
                JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                String string2 = javaNameSpace.getName();
                try {
                    JavaClass javaClass = this.getJavaClass(string2, false);
                    if (javaClass != null) {
                        return javaClass.hasField(string, object, bl);
                    }
                    return true;
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Exception occurred during JavaNameSpace hasField operation:");
                        exception.printStackTrace();
                    }
                    return true;
                }
            }

            public boolean hasMethod(String string, Object object, boolean bl) {
                try {
                    JavaNameSpace javaNameSpace = (JavaNameSpace)object;
                    JavaClass javaClass = this.getJavaClass(((JavaNameSpace)object).getName(), false);
                    if (javaClass == null) {
                        return "toString".equalsIgnoreCase(string);
                    }
                    return javaClass.hasMethod(string, object, bl);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Exception occurred during JavaNameSpace hasMethod operation:");
                        exception.printStackTrace();
                    }
                    return false;
                }
            }

            public boolean hasFieldOrMethod(String string, Object object, boolean bl) {
                return this.hasField(string, object, bl) || this.hasMethod(string, object, bl);
            }

            private JavaClass getJavaClass(String string, boolean bl) throws ClassNotFoundException {
                if (string == null || string.equals("")) {
                    return null;
                }
                if (PerAppletInfo.this.notJavaClasses.contains(string)) {
                    if (bl) {
                        throw new ClassNotFoundException(string);
                    }
                    return null;
                }
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(string, false, classLoader);
                    return PerAppletInfo.this.getJavaClass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    PerAppletInfo.this.notJavaClasses.add(string);
                    if (bl) {
                        throw classNotFoundException;
                    }
                    return null;
                }
                catch (RuntimeException runtimeException) {
                    PerAppletInfo.this.notJavaClasses.add(string);
                    throw runtimeException;
                }
            }
        }

        private class LiveConnectWorker
        implements Runnable {
            private volatile boolean shouldStop;
            private Object lock = new Object();
            private LinkedList workQueue = new LinkedList();

            private LiveConnectWorker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enqueue(JavaObjectOpMessage javaObjectOpMessage) {
                Object object = this.lock;
                synchronized (object) {
                    this.workQueue.add(javaObjectOpMessage);
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                this.shouldStop = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (!this.shouldStop) {
                        Object object = this.lock;
                        synchronized (object) {
                            while (!this.shouldStop && this.workQueue.isEmpty()) {
                                try {
                                    this.lock.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            }
                        }
                        while (!this.shouldStop && !this.workQueue.isEmpty()) {
                            object = null;
                            Object object2 = this.lock;
                            synchronized (object2) {
                                object = (JavaObjectOpMessage)this.workQueue.removeFirst();
                            }
                            PerAppletInfo.this.doObjectOp((JavaObjectOpMessage)object);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static class ReferenceCount {
        private int count = 0;

        ReferenceCount() {
        }

        public void ref() {
            ++this.count;
        }

        public int unref() {
            --this.count;
            return this.count;
        }
    }
}

